proc xgpl_Output { } {
  global Xgpl Desktop
  set w .xpglo
  catch {destroy $w}
  toplevel $w
  wm title $w "Xgnuplot Output"
  wm iconname $w "Xgnuplot Output"
  pack [frame $w.bar -relief flat] -side top -fill x -padx 2 -pady 2
  pack [button $w.bar.dismiss -relief raised -borderwidth 1 -width 10\
               -text Dismiss -command "destroy $w"] \
        -side left -anchor w
  pack [button $w.bar.plot -relief raised -borderwidth 1 -width 10\
               -text "HardCopy" -command "xgpl_OutputPlot"] \
        -side left -anchor w

  pack [frame $w.sel -relief groove -borderwidth 1] \
        -side top -fill x -padx 4 -pady 4 -expand 1
    pack [label $w.sel.filel -text File: -width 12 -relief flat] \
        -side left -anchor w -padx 4
    pack [entry $w.sel.filee -width 20 -relief sunken \
        -textvariable Xgpl(output:file)] \
        -side left -anchor w -padx 4

  pack [frame $w.type -relief groove -borderwidth 1] \
        -side top -fill x -padx 4 -pady 4 -expand 1
    pack [menubutton $w.type.sel -text "Device:" -width 12 -relief flat \
        -menu $w.type.sel.m] \
        -side left -anchor w -padx 4
      menu $w.type.sel.m
      foreach n {postscript fig} {
        $w.type.sel.m add radiobutton -label $n -variable Xgpl(output:type) \
                                      -value $n
      }
    pack [entry $w.type.type -width 20 -relief sunken \
        -textvariable Xgpl(output:type)] \
        -side left -anchor w -padx 4
}

proc xgpl_FunctionPadExit { } {
  global Xgpl Desktop
  set w .xpglf
  set Xgpl(funcs) [$w.func.text get 0.0 end]
  destroy $w
}

proc xgpl_OutputPlot { } {
  global Xgpl Desktop
  set fid $Xgpl(fidX)
  set Xgpl(fidX) [open "|gnuplot" w+]
  xgpl_FunctionApply
  xgpl_Send set terminal $Xgpl(output:type)
  xgpl_Send set output '$Xgpl(output:file)'
  xgpl_Plot
  catch {close $Xgpl(fidX)}
  set Xgpl(fidX) $fid
}
