# menu.tcl --
#
# This demonstration script creates a window with a bunch of menus
# and cascaded menus.
#
# @(#) menu.tcl 1.2 95/05/26 17:14:08

set w .menu
catch {destroy $w}
toplevel $w
wm title $w "Menu Demonstration"
wm iconname $w "menu"
positionWindow $w

frame $w.menu -relief raised -bd 2
pack $w.menu -side top -fill x

label $w.msg -font $font -wraplength 4i -justify left \
    -text {\
̃EBhE͗lXȃj[ƃJXP[hj[\Ă܂B\
Alt-X ͂ƁAXj[ɃA_[C\
tŕ\Ă镶Ȃ΁A\
L[{[h̎w肪ł܂BL[Ńj[̃go[X\łB\
j[w肳ꂽۂɂ́AXy[XL[Ŏs邱Ƃł܂B\
邢́AA_[Ct͂̕邱Ƃłsł܂B\
j[̃GgANZ[^Ăꍇ́ÃANZ[^\
͂邱ƂŃj[w肷邱ƂȂɎs邱Ƃł܂B
}

pack $w.msg -side top

frame $w.buttons
pack  $w.buttons -side bottom -expand y -fill x -pady 2m
button $w.buttons.dismiss -text  -command "destroy $w"
button $w.buttons.code -text "R[hQ" -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

set m $w.menu.file.m
menubutton $w.menu.file -text "File" -menu $m -underline 0
menu $m
$m add command -label "J ..." -command {error "́Afł̂\"J ...\"ɑ΂ANV͒`Ă܂B"}
$m add command -label "VK" -command {error "́Afł̂\"VK ...\"ɑ΂ANV͒`Ă܂B"}
$m add command -label "ۑ" -command {error "́Afł̂\"ۑ ...\"ɑ΂ANV͒`Ă܂B"}
$m add command -label "ۑ(w) ..." -command {error "́Afł̂\"ۑ(w) ...\"ɑ΂ANV͒`Ă܂B"}
$m add separator
$m add command -label "vgݒ ..." -command {error "́Afł̂\"vgݒ ...\"ɑ΂ANV͒`Ă܂B"}
$m add command -label "vg ..." -command {error "́Afł̂\"vg ...\"ɑ΂ANV͒`Ă܂B"}
$m add separator
$m add command -label "~" -command "destroy $w"

set m $w.menu.basic.m
menubutton $w.menu.basic -text "Basic" -menu $m -underline 0
menu $m
$m add command -label "ȂGg"
foreach i {a b c d e f g} {
    $m add command -label "Print letter \"$i\"" -underline 14 \
	    -accelerator Meta+$i -command "puts $i"
    bind $w <Meta-$i> "puts $i"
}

set m $w.menu.cascade.m
menubutton $w.menu.cascade -text "Cascades" -menu $m -underline 0
menu $m
$m add command -label "Print hello" \
	-command {puts stdout "hello"} -accelerator Control+a -underline 6
bind . <Control-a> {puts stdout "hello"}
$m add command -label "Print goodbye" -command {\
    puts stdout "Goodbye"} -accelerator Control+b -underline 6
bind . <Control-b> {puts stdout "Goodbye"}
$m add cascade -label "Check buttons" \
	-menu $w.menu.cascade.m.check -underline 0
$m add cascade -label "Radio buttons" \
	-menu $w.menu.cascade.m.radio -underline 0

set m $w.menu.cascade.m.check
menu $m
$m add check -label "IC_" -variable oil
$m add check -label "gX~bV_" -variable trans
$m add check -label "u[L_" -variable brakes
$m add check -label "Cg_" -variable lights
$m add separator
$m add command -label "݂̒l\" \
    -command "showVars $w.menu.cascade.dialog oil trans brakes lights"
$m invoke 1
$m invoke 3

set m $w.menu.cascade.m.radio
menu $m
$m add radio -label "10 |Cg" -variable pointSize -value 10
$m add radio -label "14 |Cg" -variable pointSize -value 14
$m add radio -label "18 |Cg" -variable pointSize -value 18
$m add radio -label "24 |Cg" -variable pointSize -value 24
$m add radio -label "32 |Cg" -variable pointSize -value 32
$m add sep
$m add radio -label "[}" -variable style -value roman
$m add radio -label "{[h" -variable style -value bold
$m add radio -label "C^bN" -variable style -value italic
$m add sep
$m add command -label "݂̒l\" \
	-command "showVars $w.menu.cascade.dialog pointSize style"
$m invoke 1
$m invoke 7

set m $w.menu.icon.m
menubutton $w.menu.icon -text "Icons" -menu $m -underline 0
menu $m
$m add command -bitmap @$tk_library/demos/images/pattern \
    -command {
	tk_dialog .pattern {Bitmap Menu Entry} {ȂIj[̍ڂ̓eLXgł͂Ȃrbg}bv\Ă܂BȊO̓_ł͑̃j[ڂƕς܂B} {} 0 
}
foreach i {info questhead error} {
    $m add command -bitmap $i -command "puts {You invoked the $i bitmap}"
}

set m $w.menu.more.m
menubutton $w.menu.more -text "More" -menu $m -underline 0
menu $m
foreach i {{Gg} {ʂ̃Gg} {Ȃ} {قƂǉȂ} {lӋ`̂}} {
    $m add command -label $i -command [list puts "You invoked \"$i\""]
}

set m $w.menu.colors.m
menubutton $w.menu.colors -text "Colors" -menu $m -underline 1
menu $m
foreach i {red orange yellow green blue} {
    $m add command -label $i -background $i \
	    -command [list puts "You invoked \"$i\""]
}

pack $w.menu.file $w.menu.basic $w.menu.cascade $w.menu.icon $w.menu.more \
	$w.menu.colors -side left
