# use_rename.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_rename"
#
proc use_rename {w packing args} {
  upvar #0 $w this

  # user initializations

  set this(command) {}
  # data initializations

  set this(use_rename) $w
  set this(entry0) $w.entry0
  set this(entry1) $w.entry1
  set this(label0) $w.label0
  set this(label1) $w.label1
  set this(apply) $w.apply
  
  # widget creations

  frame $this(use_rename) -class Use_rename
  entry $this(entry0)  \
    -relief "sunken"
  entry $this(entry1)  \
    -relief "sunken"
  label $this(label0)  \
    -anchor "w" \
    -text "Rename:"
  label $this(label1)  \
    -anchor "w" \
    -text "To:"
  button $this(apply)  \
    -command "$w _apply" \
    -text "Apply"
  
  # widget layouting

  if {$packing == "left"} {
    pack $this(apply) -side right -padx 2m
  } else {
    pack $this(apply) -side bottom -pady 2m
  }
  pack $this(label0) -side $packing -fill both
  pack $this(entry0) -side $packing -fill x -expand true
  pack $this(label1) -side $packing -fill both
  pack $this(entry1) -side $packing -fill x -expand true
  
  
  
  useCreateComponent use_rename $w $args

  # user additions

  bind $this(entry0) <Return> "focus $this(entry1)"
  bind $this(entry1) <Return> "$this(apply) flash; $this(apply) invoke"
  

  return $w
}

#
# method "_apply"
#
proc use_rename::_apply {w } {
  upvar #0 $w this

  if {$this(command) != {}} {
    eval \
    [concat $this(command) [list [$this(entry0) get]] [list [$this(entry1) get]]]
  }
  
}

#
# method "command"
#
proc use_rename::command {w args} {
  upvar #0 $w this

  set nargs [llength $args]
  
  if {$nargs == 0} {
    return $this(command)
  }
  
  if {$nargs != 1} {
    error "wrong # args, should be: command ?newcommand?"
  }
  
  set this(command) [lindex $args 0]
  
}

#
# method "show"
#
proc use_rename::show {w from {to {}}} {
  upvar #0 $w this

  $this(entry0) delete 0 end
  $this(entry0) insert 0 $from
  $this(entry1) delete 0 end
  $this(entry1) insert 0 $to
}

