# use_atools.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_atools"
#
proc use_atools {w mode args} {
  upvar #0 $w this

  # data initializations

  set this(use_atools) $w
  set this(title) $w.title
  set this(choice) $w.title.choice
  set this(menu0) $w.title.choice.menu0
  set this(chosen) $w.title.chosen
  
  # widget creations

  frame $this(use_atools) -class Use_atools
  frame $this(title)  \
    -borderwidth "2" \
    -relief "raised"
  menubutton $this(choice)  \
    -menu "$this(menu0)" \
    -text "Edit: "
  menu $this(menu0) 
  # create menu items
  
  $this(menu0) add radiobutton \
    -label {Command Line} \
    -variable $w\(mode) \
    -value {Command Line} \
    -command "$w toolcreate"
  $this(menu0) add radiobutton \
    -label {Startup Code} \
    -variable $w\(mode) \
    -value {Startup Code} \
    -command "$w toolcreate"
  $this(menu0) add separator
  $this(menu0) add command \
    -label Quit \
    -underline 0 \
    -command "destroy $w"
  label $this(chosen)  \
    -textvariable "$w\(mode)"
  
  # widget layouting

  pack $this(choice) $this(chosen) -side left -fill y
  pack $this(title) -fill x
  
  useCreateComponent use_atools $w $args

  # user additions

  set this(workarea) $this(use_atools)
  set this(tool) $this(workarea).tool
  $w mode $mode
  

  return $w
}

#
# method "mode"
#
proc use_atools::mode {w args} {
  upvar #0 $w this

  if {[llength $args] == 0} {
    return $this(mode)
  } else {
    set this(mode) [lindex $args 0]
    $w toolcreate
  }
}

#
# method "toolcreate"
#
proc use_atools::toolcreate {w } {
  upvar #0 $w this

  if [winfo exists $this(tool)] {
    destroy $this(tool)
  #  update
  }
  
  case [lindex $this(mode) 0] in {
    Command {
      use_cmdline $this(tool)
      pack $this(tool) -fill both -expand true
    }
    Startup {
      use_startup $this(tool)
      pack $this(tool) -fill both -expand true
      $this(tool) load
    }
    default {
      error "unknown mode \"$this(mode)\""
    }
  }
}

