# tkxpilots Version 2.0pl0 - funky interface to xpilots
# Copyright (C) 1993-1994 Richard Oak.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

proc put_bool value {
	global $value com

	upvar $value bool

	if {$bool == 1} {
		set com [format "%s -%s" $com $value]
	} else {
		set com [format "%s +%s" $com $value]
	}
}

proc put_real {value num} {
	global com $value

	upvar $value val

	if {$value == "shotsMass"} {
		set value shotMass
	}
        if {$value == "objectWallBrakeFactor"} {
		set value objectWallBrake
	}
	if {$value == "playerWallBrakeFactor"} {
                set value playerWallBrake
        }


	set com [format "%s -%s %d.%de-%d" $com $value [expr $val / 10] \
		[string range $val [expr [string length $val] - 1] end] $num]
}

proc put_val value {
	global $value com

	upvar $value val

	set com [format "%s -%s %d" $com $value $val]
}
	
proc start_server {} {

	global gravity shipMass shotsMass shotspeed shotLife fireRepeatRate\
                wantedNumRobots robotsLeave robotLeaveLife robotLeaveScore \
                robotLeaveRatio maxPlayerShots shotsGravity idleRun noQuit \
                mapWidth mapHeight mapFileName mapName mapAuthor contactPort \
                mapData crashWithPlayer bounceWithPlayer playerKillings \
                playerShielding playerStartsShielded shotsWallBounce \
                ballsWallBounce minesWallBounce missilesWallBounce \
                sparksWallBounce debrisWallBounce maxObjectWallBounceSpeed \
                maxShieldedWallBounceAngle maxUnshieldedWallBounceAngle \
                maxShieldedWallBounceSpeed maxUnshieldedWallBounceSpeed \
                playerWallBrakeFactor objectWallBrakeFactor \
                objectWallBounceLifeFactor wallBounceFuelDrainMult \
                wallBounceDestroyItemProb reportToMetaServer limitedVisibility \
                limitedLives worldLives teamPlay teamAssign teamImmunity \
                playerMinimumStartFuel targetKillTeam targetTeamCollision \
                treasureKillTeam treasureCollisionDestroys \
                treasureCollisionMayKill onePlayerOnly timing edgeWrap \
                edgeBounce extraBorder gravityPoint gravityAngle \
                gravityPointSource gravityClockwise gravityAnticlockwise \
                framesPerSecond allowNukes allowClusters allowModifiers \
                allowLaserModifiers allowShipShapes playersOnRadar \
                missilesOnRadar minesOnRadar nukesOnRadar distinguishMissiles \
                shieldedItemPickup shieldedMining laserIsStunGun nukeMinSmarts \
                nukeMinMines nukeClusterDamage mineFuseTime movingItemProb \
                dropItemOnKillProb destroyItemInCollisionProb itemProbMult \
                maxItemDensity itemEnergyPackProb itemTankProb itemECMProb \
                itemMineProb itemMissileProb itemCloakProb itemSensorProb \
                itemWideangleProb itemRearshotProb itemAfterburnerProb \
                itemTransporterProb itemLaserProb itemEmergencyThrustProb \
                itemTractorBeamProb itemAutopilotProb initialFuel initialTanks \
                initialECMs initialMines initialMissiles initialCloaks \
                initialSensors initialWideangles initialRearshots \
                initialAfterburners initialTransporters initialLasers \
                initialEmergencyThrusts initialTractorBeams initialAutopilots \
                gameDuration defaultsFileName motd tkxpilot_library tmp_dir \
                gravX gravY itemsWallBounce com


	foreach i {robotsLeave shotsGravity idleRun noQuit playerStartsShielded\
		itemsWallBounce shotsWallBounce ballsWallBounce minesWallBounce\
		missilesWallBounce sparksWallBounce debrisWallBounce \
		reportToMetaServer limitedVisibility limitedLives teamPlay \
		teamAssign teamImmunity targetKillTeam targetTeamCollision \
		treasureKillTeam treasureCollisionDestroys \
		treasureCollisionMayKill onePlayerOnly timing edgeWrap \
		edgeBounce extraBorder allowNukes allowClusters \
		allowModifiers allowLaserModifiers allowShipShapes \
		playersOnRadar missilesOnRadar minesOnRadar nukesOnRadar \
		distinguishMissiles shieldedItemPickup shieldedMining \
		laserIsStunGun gravityPointSource gravityClockwise \
		gravityAnticlockwise} {
			put_bool $i
		}

	foreach i {shotLife fireRepeatRate robotLeaveLife robotLeaveScore \
		robotLeaveRatio maxPlayerShots maxObjectWallBounceSpeed \
		maxShieldedWallBounceSpeed maxUnshieldedWallBounceSpeed \
		wallBounceFuelDrainMult worldLives gravityAngle \
		framesPerSecond nukeMinSmarts nukeMinMines \
		mineFuseTime itemProbMult initialFuel initialTanks \
		initialECMs initialMines initialMissiles initialCloaks \
		initialSensors initialWideangles initialRearshots \
		initialAfterburners initialTransporters initialLasers \
		initialEmergencyThrusts initialTractorBeams \
		initialAutopilots gameDuration playerMinimumStartFuel} {
			put_val $i
		}
	foreach i {itemEnergyPackProb itemTankProb itemECMProb itemMineProb \
		itemMissileProb itemCloakProb itemSensorProb \
		itemWideangleProb itemRearshotProb itemAfterburnerProb \
		itemTransporterProb itemLaserProb itemEmergencyThrustProb \
		itemTractorBeamProb itemAutopilotProb} {
			put_real $i 9
		}
	foreach i {gravity playerWallBrakeFactor objectWallBrakeFactor \
		objectWallBounceLifeFactor wallBounceDestroyItemProb \
		movingItemProb dropItemOnKillProb destroyItemInCollisionProb} { 
			put_real $i 1
		}
	
	put_real maxItemDensity 5

	put_real shotspeed 0
	put_real shipMass 0
	put_real shotsMass 1	

	if {$bounceWithPlayer == 1} {
		set com [format "%s -allowPlayerBounces" $com]
	} else {
		set com [format "%s +allowPlayerBounces" $com]
	}

	if {$crashWithPlayer == 1} {
		set com [format "%s -allowPlayerCrashes" $com]
        } else {
                set com [format "%s +allowPlayerCrashes" $com]
        }

	if {$playerKillings == 1} {
		set com [format "%s -allowPlayerKilling" $com]
        } else {
                set com [format "%s +allowPlayerKilling" $com]
        }

	if {$playerShielding == 1} {	
		set com [format "%s -allowShields" $com]
        } else {
                set com [format "%s +allowShields" $com]
        }

	set com [format "%s -gravityPoint %s" $com $gravityPoint]

	set com [format "%s -mapFileName %s" $com $mapFileName]

	set com [format "%s -robots %s" $com $wantedNumRobots]

	set com [format "%s -maxShieldedBounceAngle %d" $com $maxShieldedWallBounceAngle]

	set com [format "%s -maxUnshieldedBounceAngle %d" $com $maxUnshieldedWallBounceAngle]

	set com [format "%s -contactPort %d" $com [.mainpanel.misc.a.ent.port.ent get]]

	eval exec $com &
}
