proc draw {f w h} {
set width $w
set area [expr $width*$width]
set tmp 0
set w [genName .draw]
set sideCanvas [expr $width*40]
toplevel $w
wm title $w "Markings"
frame $w.m
canvas $w.c -height $sideCanvas -width $sideCanvas
button $w.m.dismiss -text "Dismiss" -command "destroy $w"
button $w.m.legend -text "Legend"  -command "legendSquare"
pack append $w.m $w.c top $w.m.dismiss left $w.m.legend right
pack append $w $w.m {top fillx}

set temp [expr $width-1]

#row is Y & col is X
loop num 0 $area {
   incr tmp
   loop row 0 $width {
      loop col 0 $width {
      set number [getNumber $f $row $col]
      if {$number == $tmp} {
         set Y [expr {(($row + 1)*40)-20}]
         set X [expr {(($col + 1)*40)-20}]
         if {$num == 0} {
            $w.c create oval [expr $X-3] [expr $Y-3] [expr $X+3]\
                 [expr $Y+3] -fill black
            set firstX $X
            set firstY $Y
            break
            break
            } else {
            $w.c create line $firstX $firstY $X $Y
            $w.c create oval [expr $X-3] [expr $Y-3] [expr $X+3]\
                 [expr $Y+3] -fill white -outline white
            focus $w.c
            set firstX $X
            set firstY $Y
            break
            break
            }
         }
      }
   }
}
}
