# ============================================================================
# mbar.tcl
# procs which related menu bar.
# ============================================================================

# mbar:create --
# Args -
#  maped - global data structure
#  w - parent widget name (default is .mbar)
# SideEfects -
#  (1) set up default resources for menubar itself and menus.
#  (2) create and pack menu bar stuffs.
proc mbar:create {maped {w .mbar}} {
    upvar #0 $maped data
    option add *[string trimleft $w.file.text .] "File" widgetDefault 
    option add *[string trimleft $w.edit.text .] "Edit" widgetDefault 
    option add *[string trimleft $w.view.text .] "View" widgetDefault 
    option add *[string trimleft $w.util.text .] "Util" widgetDefault 
    option add *[string trimleft $w.help.text .] "Help" widgetDefault 
    option add *[string trimleft $w*underline .] 0 widgetDefault 
    menubutton $w.file -menu $w.file.menu
    menubutton $w.edit -menu $w.edit.menu
    menubutton $w.view -menu $w.view.menu
    menubutton $w.util -menu $w.util.menu
    menubutton $w.help -menu $w.help.menu
    pack $w.file $w.edit $w.view -side left
    pack $w.help $w.util -side right

    menu $w.file.menu
    $w.file.menu add command -label New -underline 0 \
	    -command canvas:new
    $w.file.menu add command -label {load Mapfile...} -underline 5 \
	    -command [list file:loadMapfile $maped]
    $w.file.menu add command -label {load Imagefile...} -underline 5 \
	    -command [list file:loadImagefile $maped]
    $w.file.menu add command -label {Save mapfile} -underline 0 \
	    -command [list file:saveMapFile $maped]
    $w.file.menu add command -label {save mapfile As ...} -underline 13 \
	    -command [list file:saveAsMapfile $maped]
    $w.file.menu add command -label {save imageFile as ...} -underline 10 \
	    -command [list file:saveAsImageFile $maped]
    $w.file.menu add command -label {Print...} -underline 0 \
	    -command [list print:create $maped .pr]
    $w.file.menu add separator
    $w.file.menu add command -label {Exit} -underline 0 \
	    -command exit

    menu $w.edit.menu
    $w.edit.menu add command -label "Delete" -underline 0 \
	    -command "canvas:delete"
    $w.edit.menu add command -label "Cut" -underline 0 \
	    -command "canvas:cut"
    $w.edit.menu add command -label "cOpy" -underline 1 \
	    -command "canvas:copy"
    $w.edit.menu add command -label "Paste" -underline 0 \
	    -command "canvas:paste"
    $w.edit.menu add separator
    $w.edit.menu add command -label "Fore item" -underline 0 \
	    -command "canvas:fore"
    $w.edit.menu add command -label "Back item" -underline 0 \
	    -command "canvas:back"
    $w.edit.menu add separator
    $w.edit.menu add command -label "Raise image" -underline 0 \
	    -command "canvas:raise"
    $w.edit.menu add command -label "Lower image" -underline 0 \
	    -command "canvas:lower"
    
    menu $w.view.menu
    $w.view.menu add checkbutton -label "Fill" -underline 0 \
	    -variable [subst $maped](fillFlag) \
	    -command [list mbar:changeFillMode $maped]

    # External W3 Viewer
    menu $w.util.menu
    $w.util.menu add radiobutton -label {editor} -underline 0 \
	    -variable [subst $maped](utilFlag) -value {editor}
    $w.util.menu add radiobutton -label {viewer} -underline 0 \
	    -variable [subst $maped](utilFlag) -value {viewer}
    $w.util.menu add separator
    $w.util.menu add command -label {Clear} -underline 0 \
	    -command [list set [subst $maped](utilFlag) 0]

    menu $w.help.menu
    $w.help.menu add command -label "About" -underline 0 \
	    -command "help:about"
    $w.help.menu add command -label "Hand Book" -underline 0 \
	    -command "help:handbook"

    proc mbar:disable [list [list fm $w.file.menu] \
	    [list mbl [list $w.edit $w.view $w.util]]] {
	for {set i 0} {$i < 8} {incr i} {
	    $fm entryconfigure $i -state disabled
	}
	foreach i $mbl {
	    $i configure -state disabled
	}
    }
    proc mbar:enable [list [list fm $w.file.menu] \
	    [list mbl [list $w.edit $w.view $w.util]]] {
	for {set i 0} {$i < 8} {incr i} {
	    $fm entryconfigure $i -state normal
	}
	foreach i $mbl {
	    $i configure -state normal
	}
    }
}

proc mbar:changeFillMode {maped} {
    upvar #0 $maped data
    if {$data(fillFlag)} {
	canvas:fillItems
    } else {
	canvas:unFillItems
    }
}


