#!/bin/sh
# TkMapEdit Installer Ver.1.0 \
	exec wish4.1 -f $0 ${1+"$@"}
# Copyright (c) 1996 Takeshi Taguchi (translator@grape.ifnet.or.jp).
# All rights reserved.
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and documentations for *any* purpose.
# ##

# -------------------------------------------------------------------
# Following are installer itself.
# I think you never wish to edit them^^;
# -------------------------------------------------------------------
lappend auto_path ./lib .; # library dir. so you should *NOT* move
                           # this installer to any where.
set cwd [pwd]
# global resource for installer
option add *Frame.relief raised widgetDefault
option add *Frame.borderWidth 2 widgetDefault

option add *top.relief flat widgetDefault
option add *top.borderWidth 2 widgetDefault
frame .top; # setting panel
frame .bottom; # button panel
pack .top .bottom -side top -fill both -expand true

option add *Label.anchor w widgetDefault
option add *top*Entry.borderWidth 2 widgetDefault
option add *top*Entry.relief sunken widgetDefault
option add *top*Button.borderWidth 3 widgetDefault
option add *top*Button.relief raised widgetDefault
option add *top*Button.text "Browse..." widgetDefault

# usefull packer proc
proc packer {frame label entry button} {
    pack $frame -side top -fill both -expand true
    pack $label -side top -anchor w -fill x
    pack $button -side right 
    pack $entry -side left -fill x -expand true
}
proc packer2 {frame label entry} {
    pack $frame -side top -fill both -expand true
    pack $label -side top -anchor w -fill x
    pack $entry -side top -fill x -expand true
}
set maped(selectedFile) {}
set maped(tmpFormat) {}
set maped(curDrive) C
proc entryProc {maped var} {
    upvar #0 $var data
    upvar #0 $maped fs
    if {[set tmp [FileSelectionBox $maped .fs]] != {}} {
	if {[string match {*URL} $var]} {
	    return [set data "file:$tmp"]
	} else {
	    return [set data $tmp]
	}
    }
}
	
# setting panel -----------------------------------------------------
# binDir : where to copy execution
set binDir {/usr/X11R6/bin}
option add *top.bin.l.text "bin dir:" widgetDefault
frame .top.bin
label .top.bin.l
entry .top.bin.e -textvariable binDir
button .top.bin.b -command [list entryProc maped binDir]
packer .top.bin .top.bin.l .top.bin.e .top.bin.b

# libDir : where to copy libraries and icon files.
#   installer will try to copy as following dir hierarchy.
#     $libdir/lib - tcl libraries
#     $libdir/icon - icon files
#     $libdir/manifest.lst - manifest file for uninstall
set libDir {/usr/X11R6/lib/tkmapedit2}
option add *top.lib.l.text "lib dir:" widgetDefault
frame .top.lib
label .top.lib.l
entry .top.lib.e -textvariable libDir
button .top.lib.b -command [list entryProc maped libDir]
packer .top.lib .top.lib.l .top.lib.e .top.lib.b

# resDir : where to copy resource data file.
set resDir {/usr/X11R6/lib/X11/app-defaults}; # Default of XFree86(TM)
option add *top.res.l.text "resource dir:" widgetDefault
frame .top.res
label .top.res.l
entry .top.res.e -textvariable resDir
button .top.res.b -command [list entryProc maped resDir]
packer .top.res .top.res.l .top.res.e .top.res.b

# docURL : this is for help.
#   if you want to use local file, use file://... form.
set docURL {http://www.ifnet.or.jp/~translator/tools/TkMapEdit2/index-jp.html}
option add *top.doc.l.text "doc URL:" widgetDefault
frame .top.doc
label .top.doc.l
entry .top.doc.e -textvariable docURL
button .top.doc.b -command [list entryProc maped docURL]
packer .top.doc .top.doc.l .top.doc.e .top.doc.b

# servDir : this is "Server Top Dir" which is actual dir name for
# "http:/YourSiteName/". If you don't know correct value, then ask 
# your web master or your admin.
# default is nil string. this means %F translation will *NOT* perform.
# but if you don't have your local web server, and you've *NOT* use
# absolute URL path, "Util" menus will perform with *NO* probrem!
set servDir {}
option add *top.serv.l.text "server top dir:" widgetDefault
frame .top.serv
label .top.serv.l
entry .top.serv.e -textvariable servDir
button .top.serv.b -command [list entryProc maped servDir]
packer .top.serv .top.serv.l .top.serv.e .top.serv.b

# pubDir : this is a "public_html" dir name. any sites use this.
set pubDir {public_html}
option add *top.pub.l.text "public html dir:" widgetDefault
frame .top.pub
label .top.pub.l
entry .top.pub.e -textvariable pubDir
packer2 .top.pub .top.pub.l .top.pub.e

# welcomFile : welcome file name on your site.
set welcomFile {index.html}
option add *top.wel.l.text "welcom file name:" widgetDefault
frame .top.wel
label .top.wel.l
entry .top.wel.e -textvariable welcomFile
packer2 .top.wel .top.wel.l .top.wel.e

# defMapFmt : default map file format
set defMapFmt cern
option add *top.fmt.lb.text "default map file format:" widgetDefault
option add *top.fmt.Frame.relief flat widgetDefault
option add *top.fmt.Frame.borderWidth 0 widgetDefault

option add *top.fmt*Radiobutton.variable defMapFmt widgetDefault
option add *top.fmt*Radiobutton.anchor w widgetDefault
option add *top.fmt.l.cern.text "CERN HTTPD" widgetDefault
option add *top.fmt.l.ncsa.text "NCSA HTTPD" widgetDefault
option add *top.fmt.r.nets.text "Netscape NetSite" widgetDefault
option add *top.fmt.r.clnt.text "Client Side Map" widgetDefault
frame .top.fmt
label .top.fmt.lb
frame .top.fmt.l
frame .top.fmt.r
radiobutton .top.fmt.l.cern -value cern
radiobutton .top.fmt.l.ncsa -value ncsa
radiobutton .top.fmt.r.nets -value nets
radiobutton .top.fmt.r.clnt -value clnt
pack .top.fmt -side top -fill both -expand true
pack .top.fmt.lb -side top -anchor w -fill x
pack .top.fmt.l -side left -fill both -expand true
pack .top.fmt.r -side right -fill both -expand true
pack .top.fmt.l.cern .top.fmt.l.ncsa -side top -anchor w -fill x
pack .top.fmt.r.nets .top.fmt.r.clnt -side top -anchor w -fill x

# defViewer : default WWW client {netscape|surfit|tkwww}
set defViewer netscape
option add *top.view.l.text "WWW Viewer:" widgetDefault
option add *top.view.Frame.relief flat widgetDefault
option add *top.view.Frame.borderWidth 0 widgetDefault
option add *top.view*Radiobutton.variable defViewer  widgetDefault
option add *top.view.b.netscape.text "Netscape 2.x" widgetDefault
option add *top.view.b.surfit.text "SurfIt!" widgetDefault
option add *top.view.b.tkwww.text "TkWWW" widgetDefault
frame .top.view
label .top.view.l
frame .top.view.b
radiobutton .top.view.b.netscape -value netscape
radiobutton .top.view.b.surfit -value surfit
radiobutton .top.view.b.tkwww -value tkwww
pack .top.view -side top -fill both  -expand true
pack .top.view.l -side top -anchor w -fill x
pack .top.view.b -side top -fill both -expand true
pack .top.view.b.netscape .top.view.b.surfit .top.view.b.tkwww \
	-side left -anchor w -fill x -expand true -padx 5

# defEditor : default HTML Editor {emacs|mule|tkhtml}
set defEditor emacs
option add *top.edit.l.text "WWW Editor:" widgetDefault
option add *top.edit.Frame.relief flat widgetDefault
option add *top.edit.Frame.borderWidth 0 widgetDefault
option add *top.edit*Radiobutton.variable defEditor  widgetDefault
option add *top.edit.b.emacs.text "Emacs" widgetDefault
option add *top.edit.b.mule.text "Mule" widgetDefault
option add *top.edit.b.tkhtml.text "TkHTML 2.x" widgetDefault
frame .top.edit
label .top.edit.l
frame .top.edit.b
radiobutton .top.edit.b.emacs -value emacs
radiobutton .top.edit.b.mule -value mule
radiobutton .top.edit.b.tkhtml -value tkhtml
pack .top.edit -side top -fill both  -expand true
pack .top.edit.l -side top -anchor w -fill x
pack .top.edit.b -side top -fill both -expand true
pack .top.edit.b.emacs .top.edit.b.mule .top.edit.b.tkhtml \
	-side left -anchor w -fill x -expand true -padx 5

# anicon, aniDelay : animate icon stuff.
set anicon 1
set aniDelay 1000
option add *top.anicon.l.text "Use Animate Icon:" widgetDefault
option add *top.anicon.Frame.relief flat widgetDefault
option add *top.anicon.Frame.borderWidth 0 widgetDefault
option add *top.anicon*Radiobutton.variable anicon  widgetDefault
option add *top.anicon.b.true.text "Yes" widgetDefault
option add *top.anicon.b.false.text "No" widgetDefault
option add *top.anicon*Scale.orient horizontal widgetDefault
option add *top.anicon*Scale.label Delay: widgetDefault
option add *top.anicon*Scale.relief sunken widgetDefault
option add *top.anicon*Scale.to 1200 widgetDefault
option add *top.anicon*Scale.variable aniDelay widgetDefault
frame .top.anicon
label .top.anicon.l
frame .top.anicon.b
radiobutton .top.anicon.b.true -value 1 -command \
	[list .top.anicon.s configure -state normal -relief sunken]
radiobutton .top.anicon.b.false -value 0 -command \
	[list .top.anicon.s configure -state disabled -relief flat]
scale .top.anicon.s
pack .top.anicon -side top -fill both -expand true
pack .top.anicon.l -side top -fill x
pack .top.anicon.b -side top -fill both -expand true
pack .top.anicon.b.true .top.anicon.b.false \
	-side left -anchor w -fill x -expand true -padx 5
pack .top.anicon.s -side top -fill x -expand true

# buttons ----------------------------------------------

option add *bottom*Frame.borderWidth 2 widgetDefault
option add *bottom*Frame.relief flat widgetDefault

option add *bottom.compile.b.text {Compile} widgetDefault
frame .bottom.compile
button .bottom.compile.b -command compileProc
pack .bottom.compile.b -padx 5 -pady 5

option add *bottom.install.b.text {Install} widgetDefault
frame .bottom.install
button .bottom.install.b -command installProc
pack .bottom.install.b -padx 5 -pady 5

option add *bottom.uninstall.b.text {un-Install} widgetDefault
frame .bottom.uninstall
button .bottom.uninstall.b -command unInstallProc
pack .bottom.uninstall.b -padx 5 -pady 5

option add *bottom.dismiss.b.text {Dismiss} widgetDefault
frame .bottom.dismiss
button .bottom.dismiss.b -command exit
pack .bottom.dismiss.b -padx 5 -pady 5
pack .bottom.compile .bottom.install .bottom.uninstall .bottom.dismiss \
	-side left -padx 5 -pady 5

proc progressWin {w t v} {
    toplevel $w -class Dialog
    wm title $w Progress
    wm iconname $w Progress
    scale $w.s -variable $v -state disabled -label $t -to 100 -fro 0 \
	    -sliderlength 5 -length 100 -relief raised \
	    -orient horizontal -troughcolor blue
    pack $w.s
}


proc compileProc {} {
    global binDir libDir resDir servDir pubDir anicon aniDelay
    global welcomFile defMapFmt defViewer defEditor docURL cwd
    global progress
    set progress 0
    progressWin .p Compile progress
    # cleate Resource File
    catch [list cd $cwd]
    set fp [open "Tkmped2.ad" w]
    puts $fp "! --- Tkmped - TkMapEdit Ver2.1 Resource File ---"
    puts $fp "! ICON stuff"
    puts $fp "*defaultIconPath: $libDir/icon"
    if {$anicon} {
	puts $fp "*animateIcon: True"
	puts $fp "*animateDelay: $aniDelay"
    } else {
	puts $fp "*animateIcon: False"
    }	
    set progress 10; update
    puts $fp "! documentation URL"
    puts $fp "*docURL: $docURL"
    puts $fp "! Server Structure"
    puts $fp "*serverTopDir: $servDir"
    puts $fp "*publicHtmlDir: $pubDir"
    puts $fp "*welcomeHtml: $welcomFile"
    puts $fp "! Default Format"
    set progress 20; update
    switch $defMapFmt {
	cern {
	    puts $fp "*mapFormat: {{{CERN Httpd} {}} {{NCSA Httpd} {}} {{NetSite} 3} {{Client Side Map} 12}}"
	}
	ncsa {
	    puts $fp "*mapFormat: {{{NCSA Httpd} {}} {{CERN Httpd} {}} {{NetSite} 3} {{Client Side Map} 12}}"
	}
	nets {
	    puts $fp "*mapFormat: {{{NetSite} 3} {{NCSA Httpd} {}} {{CERN Httpd} {}} {{Client Side Map} 12}}"
	}
	clnt {
	    puts $fp "*mapFormat: {{{Client Side Map} 12} {{NetSite} 3} {{NCSA Httpd} {}} {{CERN Httpd} {}}}"
	}
    }
    set progress 30; update
    puts $fp "! Util Stuff"
    switch $defViewer {
	netscape {
	    puts $fp "*viewerExec: exec netscape -remote openURL(%U)"
	}
	surfit {
	    puts $fp "*viewerExec: send surfit {create_window %U}"
	}
	tkwww {
	    puts $fp "*viewerExec: send tkwww {tkW3NavigateGoto %U}"
	}
    }
    switch $defEditor {
	emacs -
	mule {
	    puts $fp "*editorExec: exec emacsclient %F"
	}
	tkhtml {
	    puts $fp "*editorExec: send tkHTML {OpenFile %F}"
	}
    }
    catch [list close $fp]
    # rewrite Tcl files
    set progress 40; update
    set regDat(@LOCALLIBDIR@) $libDir/lib
    set regDat(@DEFAULTICONPATH@) $libDir/icon
    file:copyWithRegsub tkmped2.in tkmped2 regDat
    set progress 50; update
    unset regDat
    set regDat(@APPDEFAULTSPATH@) $resDir
    file:copyWithRegsub lib/res.in lib/res.tcl regDat
    set progress 60; update
    cd $cwd/lib
    eval auto_mkindex . [glob *.tcl]
    cd $cwd
    set progress 100; update; destroy .p
    
}

proc makedir {path} {
    if {[file isdirectory $path]} {
	return $path
    } elseif {[file exists $path]} {
	tkerror "Non-Directory! $path already exists."
	return
    } else {
	makedir [file dirname $path]
	exec mkdir $path
	return $path
    }
}

proc installProc {} {
    global binDir libDir resDir cwd
    global progress
    set progress 0
    progressWin .p Install progress
    catch [list cd $cwd]
    catch [list makedir $libDir]
    catch [list makedir $libDir/lib]
    catch [list makedir $libDir/icon]
    set logFp [open $libDir/manifest.lst w]
    foreach i [concat [glob lib/*.tcl] lib/tclIndex] {
	file:copy $i $libDir/$i
	puts $logFp "$libDir/$i"
	incr progress 3; update
    }
    catch [list makedir $libDir/icon]
    foreach i [concat [glob icon/*.ppm] [glob icon/*.xbm]] {
	file:copy $i $libDir/$i b
	puts $logFp "$libDir/$i"
	incr progress; update
    }
    catch [list makedir $resDir]
    file:copy Tkmped2.ad $resDir/Tkmped2
    puts $logFp "$resDir/Tkmped2"
    set progress 80; update
    catch [list makedir $binDir]
    file:copy tkmped2 $binDir/tkmped2
    catch [list exec chmod a+x $binDir/tkmped2]
    puts $logFp "$binDir/tkmped2"
    puts $logFp "$libDir/manifest.lst"
    catch [list close $logFp]
    set progress 100; update; destroy .p
}

proc unInstallProc {} {
    global binDir libDir resDir
    if {[regexp {[A-Z]:\\.*} [pwd] dummy] == 1} {
	set rmProc "del"
	set rmdirProc "rd"
    } else {
	set rmProc "rm -f"
	set rmdirProc "rmdir"
    }
    set logFp [open $libDir/manifest.lst w]
    while {[gets $logFp line] >= 0} {
	eval [list exec $rmProc $line]
    }
    eval $rmdirProc $libDir
    catch [list close $logFp]
}


