# ps.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script generates a window with the  possibility to include a post-
# scriptfile.
#----------------------------------------------------------------------------

#---------------------------------------------------------------------------
#### proc wrapps ####
#---------------------------------------------------------------------------

proc wrapps {} {
destroy .ps
}

#---------------------------------------------------------------------------
#### proc includeps ####
#---------------------------------------------------------------------------
proc includeps {psname} {
global breakpoint
global currenttext
global winnumber
global includenum
global sumofwin
global currentwidgetnumber
global widgetname
global contenttype
global body
global description
global bg1 bg2 actbg bheight

set sumofwin [expr $sumofwin+1]
set includenum [expr $includenum+1]
set currentframe [split $currenttext .]
set part2 [lindex $currentframe 2]
set currentframe .[lindex $currentframe 1]
## Checks if cursor doesn't stand in an textfield, then the input will be first
if {$part2 !="text"} {
   set currenttext $widgetname(1)
   set currentframe [split $currenttext .]
   set currentframe .[lindex $currentframe 1]
   set breakpoint 1.0
   }
frame .f$includenum -background $bg1
#### if first position in the current textwidget
if {$breakpoint=="1.0"} {
   pack .f$includenum -fill both -side top -before $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x
   updatesendlist $currentwidgetnumber($currenttext) $sumofwin
   set currentwidgetnumber(.f$includenum.canvas) \
        [expr $currentwidgetnumber($currenttext)-1]
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) .f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"application/postscript\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "\[exec mimencode -b $psname\] base64\] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "psfile : $psname"
   # # # # #
} else {
   pack .f$includenum -fill both -side top -after $currentframe
   text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
   scrollbar .f$includenum.scroll  -relief flat  -background $bg2 -foreground \
        $bg2 -activeforeground $actbg -command ".f$includenum.text yview"
   pack .f$includenum.scroll -side right -fill y
   pack .f$includenum.text -expand yes -fill both
   .f$includenum.text insert 1.0 [ $currenttext get insert end]
   $currenttext delete insert end
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin

   set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)+1]
   set widgetname($currentwidgetnumber(.f$includenum.text)) .f$includenum.text
   set contenttype($currentwidgetnumber(.f$includenum.text)) \
        "\[SafeTcl_makebody \"text/plain\" "
   set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
   set description($currentwidgetnumber(.f$includenum.text)) \
        "textfield"
   set sumofwin [expr $sumofwin+1]
   set includenum [expr $includenum+1]
   frame .f$includenum -background $bg1
   pack .f$includenum -fill both -side top -after $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x

   set currentwidgetnumber(.f$includenum.canvas) [expr \
        $currentwidgetnumber($currenttext)+1]
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
	.f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"application/postscript\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "\[exec mimencode -b $psname\] base64\] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "psfile : $psname"
   }

.f$includenum.canvas create text 1 10 -text "psfile : $psname" \
	-anchor w
destroy .ps
.butt.label configure -text "Including a postscriptfile...done" -foreground \
	#000000
}

#----------------------------------------------------------------------------
#### psmenu ####
#----------------------------------------------------------------------------
proc psmenu {} {
global type
global numberoftype
global localname
global psname
global bg1 bg2 actbg

toplevel .ps
wm title .ps "A ps file"
wm iconname .ps "PS"

label .ps.header1 -text "A postscript-file" -background $bg1 -background \
	$bg1 -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" -foreground red
label .ps.header2 -text "Do you want to include the following as a ps-file" \
	-background $bg1
pack .ps.header1 -side top -fill x
pack .ps.header2 -side top -fill x

frame .ps.f0 -background $bg2 -relief ridge -borderwidth 2
pack .ps.f0 -fill both
label .ps.f0.file -width 12 -text "File               :" -background $bg2
label .ps.f0.psname -width 60  -background $bg2 -text $psname -anchor w
pack .ps.f0.file -side left -anchor w
pack .ps.f0.psname -side left

#----------------------------------------------------------------------------
# Button actions
#----------------------------------------------------------------------------
frame .ps.f2 -background $bg1
pack .ps.f2 -fill both
button .ps.f2.include -text Include -command {includeps $psname} \
	-background $bg1 -activebackground $actbg
button .ps.f2.quit -text Cancel -command "wrapps; .butt.label configure \
	-text \"Including a postscriptfile...Cancelled\" -foreground #000000" \
	-background $bg1 -activebackground $actbg
button .ps.f2.listdir -text "New FSBox" -command {wrapps;ps} \
	-background $bg1 -activebackground $actbg
pack .ps.f2.include .ps.f2.quit .ps.f2.listdir -side left -expand yes -pady 5

catch {grab .ps}
}

#---------------------------------------------------------------------------
#### proc ps ####
# Creates a FSBox with the label Select a psfile
#---------------------------------------------------------------------------
proc ps {} {
global fsBoxMessage
global psname

.butt.label configure -text "Including a postscriptfile..." -foreground #3d55ff
set fsBoxMessage "Select a postscriptfile"
set psname [FSBox]
if [file isfile $psname] {
   psmenu 
   }
}
