# about.tcl
#
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script generates first a window with a bit information about
# the copyright. Then you can get new windows with info about the author 
# and the program. 
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
# This proc generates a window with a bit information about the author
#----------------------------------------------------------------------------

proc aboutauthor {} {
global bg1 actbg
.butt.label configure -text "About Author..." -foreground #3d55ff
toplevel .aboutauthor
label .aboutauthor.label1 -text "The author..." -foreground red \
        -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" -background $bg1
pack .aboutauthor.label1 -fill x
canvas .aboutauthor.canvas -relief ridge -background $bg1 -width 500 \
        -height 170 -borderwidth 2
pack .aboutauthor.canvas -fill x
.aboutauthor.canvas create text 1 90 -anchor w \
        -text { ...is a swedish student, who made a training during
 half a year at Siemens KWU in the German town Erlangen.

 Unfortunately he does not know how much time he has for 
 a new version of Tkmailto in the future.

 You can reach the author by the mailaddress:
 - de3t922@tintin.hik.se
}
frame .aboutauthor.f1 -background $bg1
pack .aboutauthor.f1 -side bottom -fill x

button .aboutauthor.f1.about -text "About.." -command {destroy .aboutauthor; \
        about}  -background $bg1 -activebackground $actbg -width 15
button .aboutauthor.f1.tkmailto -text "About Tkmailto.." -command {destroy .aboutauthor; \
        abouttkmailto }  -background $bg1 -activebackground $actbg -width 15
button .aboutauthor.f1.ok -text Enough -command {destroy .aboutauthor; \
	.butt.label  configure -text "About...Enough" -foreground #000000} \
	-background $bg1 -activebackground $actbg  -width 15
pack .aboutauthor.f1.about -side left
pack .aboutauthor.f1.tkmailto -side left -expand y
pack .aboutauthor.f1.ok  -side right
grab .aboutauthor
}

#----------------------------------------------------------------------------
# This proc generates a window with a bit information about the program
#----------------------------------------------------------------------------
proc abouttkmailto {} {
global bg1 actbg
.butt.label configure -text "About Tkmailto..." -foreground #3d55ff
toplevel .abouttkmailto
label .abouttkmailto.label1 -text "Tkmailto..." -foreground red -background \
        $bg1 -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" 
pack .abouttkmailto.label1 -fill x
canvas .abouttkmailto.canvas -relief ridge -background $bg1 -width 500 \
	-height 200 -borderwidth 2
pack .abouttkmailto.canvas -fill x
.abouttkmailto.canvas create text 1 100 -anchor w \
	-text { ...is a mailcomposer for MIME-message.
 It is implemented in the programlanguages Tcl/Tk and Safe-Tcl.
 The functionallity is based on the program mailto.

 Notice that the program is just a light-weight program,
 and don't expect too much 
}
frame .abouttkmailto.f1 -background $bg1
pack .abouttkmailto.f1 -side bottom -fill x

button .abouttkmailto.f1.tkmailto -text "About.." -command \
	{destroy .abouttkmailto; about}  -background $bg1 \
	-activebackground $actbg -width 15
button .abouttkmailto.f1.author -text "About author.." -command \
	{destroy .abouttkmailto; aboutauthor}  -background $bg1 \
	-activebackground $actbg -width 15
button .abouttkmailto.f1.ok -text Enough -command {destroy .abouttkmailto; \
	.butt.label  configure -text "About...Enough" -foreground #000000} \
	-background $bg1 -activebackground $actbg  -width 15

pack .abouttkmailto.f1.tkmailto -side left
pack .abouttkmailto.f1.author -side left -expand y
pack .abouttkmailto.f1.ok  -side right
grab .abouttkmailto

}

#----------------------------------------------------------------------------
# This proc generates a window with a bit information about the copyright
#----------------------------------------------------------------------------
proc about {} {
global bg1 actbg
.butt.label configure -text "About..." -foreground #3d55ff
toplevel .about
label .about.label1 -text "About..." -foreground red -background \
	$bg1 -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" 
pack .about.label1 -fill x
canvas .about.canvas -relief ridge -background $bg1 -width 600 \
        -height 200 -borderwidth 2
pack .about.canvas -fill x
.about.canvas create text 1 100 -anchor w \
        -text { ...Copyright 1994 Siemens KWU Erlangen
 Permission to use, copy, modify, and distribute this source
 is hereby granted, provided that the copyright notice appears
 in all copies. This software is provided without any warranty, express
 or implied. Siemens KWU Erlangen makes no representations about the
 suitability of this software for any purpose.

 Author: Johan Linbladh (jtet90jl@tintin.hik.se)
}
frame .about.f1 -background $bg1
pack .about.f1 -side bottom -fill x

button .about.f1.tkmailto -text "About Tkmailto.." -command {destroy .about; \
        abouttkmailto }  -background $bg1 -activebackground $actbg -width 15
button .about.f1.author -text "About author.." -command {destroy .about; \
	aboutauthor}  -background $bg1 -activebackground $actbg -width 15
button .about.f1.ok -text Enough -command {destroy .about; .butt.label \
	configure -text "About...Enough" -foreground #000000} -background $bg1 \
	-activebackground $actbg  -width 15

pack .about.f1.tkmailto -side left 
pack .about.f1.author -side left -expand y
pack .about.f1.ok  -side right 
grab .about

}



