#
# Tcl library for TkCVS
#

#
# filebrowse.tcl,v 1.4 1995/08/19 11:47:30 del Exp
#
# Sets up a dialog to browse the contents of a module.
#

proc browse_files {mcode} {
  global filenames
  global mtitle

  static {browser 0}

  if {! [info exists mtitle($mcode)]} {
    cvserror "Sorry, this function only works on modules, not directories!"
    return
  }

  # Find the list of file names.
  find_filenames $mcode

  if {! [info exists filenames($mcode)]} {
    cvserror "There are no files in this module!"
    return
  }

  #
  # Create the browser window.
  #

  incr browser
  set filebrowse ".filebrowse$browser"
  toplevel $filebrowse
  frame $filebrowse.up   -relief groove -border 2
  frame $filebrowse.up.left
  frame $filebrowse.up.right
  frame $filebrowse.down -relief groove -border 2

  pack $filebrowse.up -side top -fill x
  pack $filebrowse.up.left -side left -fill both
  pack $filebrowse.up.right -side left -fill both -expand 1
  pack $filebrowse.down -side bottom -fill x

  label $filebrowse.lver1 -anchor w -text "Version / Tag "
  # label $filebrowse.lver2 -anchor w -text "Version / Tag 2 (diff)"

  entry $filebrowse.tver1 -relief sunken
  # bind_motifentry $filebrowse.tver1
  # entry $filebrowse.tver2 -relief sunken
  # bind_motifentry $filebrowse.tver2

  pack $filebrowse.lver1 -in $filebrowse.up.left \
    -side top -fill x -pady 3
  pack $filebrowse.tver1 -in $filebrowse.up.right \
    -side top -fill x -pady 3

  #
  # Create buttons
  #

  button $filebrowse.help -text "Help" \
    -command file_browser
  button $filebrowse.view -text "View" \
    -command "fileview $filebrowse $mcode"
  button $filebrowse.log -text "Log Browse" \
    -command "filelog $filebrowse.list $mcode"
  # button $filebrowse.diff -text "Diff" \
  #   -command "filediff $filebrowse $mcode"
  button $filebrowse.quit -text "Quit" \
    -command "destroy $filebrowse"
  pack $filebrowse.help $filebrowse.view \
    $filebrowse.log $filebrowse.quit \
    -in $filebrowse.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1

  #
  # Create a scrollbar and a list box.
  #

  scrollbar $filebrowse.scroll -relief sunken \
    -command "$filebrowse.list yview"
  listbox $filebrowse.list \
    -yscroll "$filebrowse.scroll set" -relief sunken \
    -width 40 -height 15 -setgrid yes
  pack $filebrowse.scroll -side right -fill y -padx 2 -pady 2
  pack $filebrowse.list -side left -fill both -expand 1

  #
  # Window manager stuff.
  #

  wm title $filebrowse "Files in $mcode"
  wm minsize $filebrowse 1 1

  #
  # Fill the list.
  #
  foreach file $filenames($mcode) {
    $filebrowse.list insert end $file
  }
}

proc filelog {listname mcode} {

  foreach item [$listname curselection] {
    cvs_filelog $mcode [$listname get $item]
  }
}

# proc filediff {toplevelname mcode} {
# 
#   set listname $toplevelname.list
#   foreach item [$listname curselection] {
#     cvs_filediff $mcode [$listname get $item] \
#      [$toplevelname.tver1 get] [$toplevelname.tver2 get] 
#   }
# }

proc fileview {toplevelname mcode} {

  set listname $toplevelname.list
  foreach item [$listname curselection] {
    cvs_fileview $mcode [$listname get $item] [$toplevelname.tver1 get]
  }
}
