#
# Tcl Library for tkCVS
#
 
# 
# update.tcl,v 1.5 1995/08/19 11:47:32 del Exp
#
# Set up a small update dialog.
#

proc update_setup {} {

  toplevel .update
  frame .update.left
  frame .update.right
  frame .update.down -relief groove -border 2

  pack .update.down -side bottom -fill x
  pack .update.left -side left -fill y
  pack .update.right -side left -fill both -expand 1

  label .update.lname -text "Tag Name" -anchor w

  entry .update.tname -relief sunken -textvariable updatename

  # bind_motifentry .update.tname

  pack .update.lname -in .update.left \
    -side top -fill x -pady 3
 
  pack .update.tname -in .update.right \
    -side top -fill x -pady 3
 
  button .update.ok -text "OK" \
    -command {
      eval "cvs_update $updatename [workdir_list_marked_files]"
      wm withdraw .update
    }
  button .update.quit -text "Quit" -command { wm withdraw .update }
 
  pack .update.ok .update.quit -in .update.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1
 
  wm withdraw .update
  wm title .update "Update a Module"
  wm minsize .update 1 1
}

proc update_run {} {
  global incvs
  global cvscfg

  if {! $incvs} {
    cvserror "This directory is not in CVS.\nPlease import it first."
    return 1
  }

  wm deiconify .update
}
