^TI^'
^TITW^trace variable 
^TIS^name ops command
^TI^' Command
^P^
Arrange for 
^S^command
 to be executed whenever variable 
^S^name
 is accessed in one of the ways given by 
^S^ops
. 
^S^name
 may refer to a normal variable, an element of an array, 
or to an array as a whole (i.e. 
^S^name
 may be just the name of an array, with no 
parenthesized index). If 
^S^name
 refers to a whole 
array, then 
^S^command
 is invoked whenever any element 
of the array is manipulated.
^P^
^S^ops
 indicates which operations are of interest, and 
consists of one or more of the following letters:
^P^
^B^r
 : Invoke 
^S^command
 whenever the variable 
is read.
^P^
^B^w
 : Invoke 
^S^command 
whenever the variable is written.
^P^
^B^u
 : Invoke 
^S^command
 whenever the variable is unset. Variables can be unset explicitly with the 
^B^unset
 command, or implicitly (eg. when procedures return all of their local 
variables are unset). Variables are also unset 
when interpreters are deleted, but traces will not be invoked because 
there is no interpreter in which to 
execute them.
^P^
When the trace triggers, three arguments are 
appended to 
^S^command
 so that the actual command is 
as follows: 
^P^
^T^
^B^command 
^S^name1 name2 op 
^P^
^S^name1
 and 
^S^name2
 give the name(s) for the variable 
being accessed: if the variable is a scalar then 
^S^name1 gives the variable's name and ^S^name2 is an 
empty string; if the variable is an array element 
then 
^S^name1
 gives the name of the array and 
^S^name2
 gives the index into the array; if an entire array 
is being deleted and the trace was registered on 
the overall array, rather than a single element, 
then 
^S^name1
 gives the array name and 
^S^name2
 is an empty string. 
^S^op
 indicates what operation is being 
performed on the variable, and is one of 
^B^r
, 
^B^w
, or 
^B^u 
as defined above.
^P^
^TI^Execution Context of the Command Argument
^P^
^S^command
 executes in the same context as the code 
that invoked the traced operation: if the variable 
was accessed as part of a Tcl procedure, then 
^S^command
 will have access to the same local variables 
as code in the procedure. This context may be different than the 
context in which the trace was created. If 
^S^command
 invokes a procedure (which it 
normally does) then the procedure will have to use 
^B^upvar
 or 
^B^uplevel
 if it wishes to access the traced variable. Note also that 
^S^name1
 may not necessarily be the same as the name used to set the trace on 
the variable; differences can occur if the access 
is made through a variable defined with the 
^B^upvar 
command.
^P^
^TI^Details on Read and Write Traces
^P^
For read and write traces, 
^S^command
 can modify the 
variable to affect the result of the traced operation. 
A common use for this feature is to put a trace on an entire array, 
such that if an attempt is made to access a nonexistent element of the 
array, the trace will automatically create and initialize that element, thus 
hiding from the program that the array element did not exist previous to 
the attempt to read it. If 
^S^command
 modifies the value of a variable 
during a read or write trace, then the new value 
will be returned as the result of the traced operation. The return value from 
^S^command
 is ignored 
except that if it returns an error of any sort then 
the traced operation also returns an error with the 
same error message returned by the trace command 
(this mechanism can be used to implement read-only 
variables, for example). For write traces, 
^S^command 
is invoked after the variable's value has been 
changed; it can write a new value into the variable 
to override the original value specified in the 
write operation. To implement read-only variables, 
^S^command
 will have to restore the old value of the 
variable.
^P^
While 
^S^command
 is executing during a read or write 
trace, traces on the variable  are temporarily disabled. 
This means that reads and writes invoked by 
^S^command
 will occur directly, without invoking command 
(or any other traces) again. However, if 
^S^command
 unsets the variable 
then unset traces will be invoked.
^P^
^TI^Details of Unset Traces
^P^
When an unset trace is invoked, the variable has 
already been deleted: it will appear to be 
undefined with no traces. If an unset occurs 
because of a procedure return, then the trace will 
be invoked in the variable context of the procedure 
being returned to: the stack frame of the returning procedure 
will no longer exist. Traces are not 
disabled during unset traces, so if an unset trace 
command creates a new trace and accesses the variable, 
the trace will be invoked. Any errors in 
unset traces are ignored.
^P^
^TI^Lifetime of Traces and Miscellanea
^P^
Once created, the trace remains in effect either 
until the trace is removed with the 
^B^trace vdelete 
 command, until the variable is 
unset, or until the interpreter is deleted. Unsetting an element 
of array will remove any traces on 
that element, but will not remove traces on the 
overall array.
^P^
If there are multiple traces on a variable they are 
invoked in order of creation, most-recent first. 
If one trace returns an error, then no further 
traces are invoked for the variable. If an array 
element has a trace set, and there is also a trace 
set on the array as a whole, the trace on the overall 
array is invoked before the one on the element. 
^P^
This command returns an empty string. 







