^TI^'
^TITW^scan 
^TIS^string format varName...
^TI^' Command
^P^
This command parses fields from an input string returns a 
count of the number of conversions performed, or -1 if the 
end of the input string is reached before any conversions 
have been performed. 
^S^string
 gives the input to be parsed 
and 
^S^format
 indicates how to parse it. Each 
^S^varName
 gives the name of a 
variable; when a field is scanned from 
^S^string
 the result is converted back into a string and assigned to the 
corresponding variable.
^P^
^TI^Details on Scanning
^P^
^B^scan
 operates by scanning 
^S^string
 and 
^S^format
 together. If the next character in 
^S^format
 is a blank or tab then it matches any number of white space 
characters in 
^S^string
 (including zero). Otherwise, if it 
isn't a % character then it must match the next character 
of 
^S^string
. When a % is encountered in 
^S^format
, it 
indicates the start of a 
^I^conversion specifier
. A conversion specifier contains up to three fields after the %: an 
optional *, 
which if present indicates that the converted value is to be discarded 
instead of assigned to a variable; an optional number indicating a maximum 
field width (in characters); and a required conversion character. 
^P^ 
When 
^B^scan
 finds a conversion specifier in 
^S^format
, it 
first skips any white-space characters in 
^S^string
. Then it converts the next input characters according to the 
conversion specifier and stores the result in the variable 
given by the next 
^S^varName
 argument to 
^B^scan
. The following conversion characters are supported:
^P^
^B^d
 : The input field must be a decimal integer. It 
is read in and the value is stored in the variable as a decimal string.
^P^
^B^o
 : The input field must be an octal integer. It is 
read in and the value is stored in the variable 
as a decimal string.
^P^
^B^x
 : The input field must be a hexadecimal integer. 
It is read in and the value is stored in the 
variable as a decimal string.
^P^
^B^c
 : A single character is read in and its 
^I^binary value
 is stored in the variable as a decimal 
string. Initial white space is not skipped in 
this case, so the input field may be a white-space 
character. The input field 
always consists of a single character and no 
field width may be specified.
^P^
^B^s
 : The input field consists of all the characters 
up to the next white-space character; the characters 
are copied to the variable.
^P^
^B^e
 or 
^B^f
 or 
^B^g
 : The input field must be a floating-point number 
consisting of an optional 
^I^sign
 (
^B^+
 or 
^B^-
), a string of 
^I^decimal digits
 possibly containing a 
^I^decimal point
, and an optional 
^I^exponent
 consisting of an 
^B^e
 or 
^B^E
 followed by an optional sign and a string of 
decimal digits. It is read in and stored in the 
variable as a floating-point string.
^P^
^B^[
^I^chars
^B^]
 : The input field consists of any number of the characters specified in 
^S^chars
. The matching string is stored 
in the variable. If the first character between 
the brackets is a 
^B^]
 then it is treated as part 
of 
^S^chars
 rather than the closing bracket for the 
set.
^P^
^B^[^
^I^chars
^B^]
 : The input field consists of any number of char acters 
^I^not
 in 
^S^chars
. The matching string is 
stored in the variable. If the character immediately following the 
^B^^
 is a 
^B^]
 then it is treated as part of the set rather than the closing 
bracket for the set.
^P^
The number of characters read from the input for a conversion 
is the largest number that makes sense for that particular conversion 
(e.g. as many decimal digits as possible for 
^B^%d
, as many octal digits as possible for 
^B^%o
, and so on). The input field for a given conversion terminates 
either when a white-space character is encountered or when 
the maximum field width has been reached, whichever comes 
first. If a 
^B^*
 is present in the conversion specifier then 
no variable is assigned and the next 
^B^varName
 argument is not consumed.
^P^
^TI^Differences from ANSI 'sscanf'
^P^
Programmers familiar with C will recognize that the behavior of the 
^B^scan
 command is the same as the 
behavior of the ANSI C 
^B^sscanf
 procedure except for the following differences:
^P^
[1] 
^B^%p
 and 
^B^%n
 conversion specifiers are not currently 
supported.
^P^
[2] For 
^B^%c
 conversions a single character value is converted to a 
decimal string, which is then assigned 
to the corresponding 
^S^varName
; no field width may be specified for this conversion.
^P^
[3] The 
^B^l
, 
^B^h
, and 
^B^L
 modifiers are ignored; integer values are always converted as 
if there were no modifier present and real values are always 
converted as if the 
^B^l
 modifier were present (i.e. type 
^B^double
 is used for the internal representation).
^P^
Of course, if you don't know C, then the above points needn't concern 
you.
