^TI^'
^TITW^error 
^TIS^message 
^TIS^info 
^TIS^code 
^TI^' Command
^P^
Returns a 
^B^TCL_ERROR
 code, which causes command interpretation 
to be unwound. In practical terms, this means that execution of 
the current script will be terminated, and either the program 
will halt entirely, or (if this script is executing within a 
^B^catch
 statement) control will be returned to the innermost enclosing 
^B^catch. 
^S^message
 is a string that is returned 
to the application to indicate what went wrong. 
^P^
In order to help debugging errors in Tcl 
scripts, any 
^B^error
 command will cause the Tcl interpreter to record information about 
all of the commands and procedures it has to "unwind" from as a result 
of terminating normal execution; this information 
is recorded in the global variable 
^B^errorInfo
. If the 
^S^info
 argument is present, it is used to initialize 
^B^errorInfo
, and the first increment of unwind information 
will not be added by the Tcl interpreter. In other words, 
the command containing the error command will not appear 
in 
^B^errorInfo
; in its place will be 
^S^info
. This feature is 
most useful in conjunction with the 
^B^catch
 command: if a caught error cannot be handled successfully, 
^S^info
 can be used to return a stack trace reflecting the original point 
of occurrence of the error:
^P^

^TW^catch {...} errMsg
^p^
^T^
^TW^set savedInfo $errorInfo
^p^
^T^
^TW^...
^p^
^TW^error $errMsg $savedInfo
^P^
If the 
^S^code
 argument is present, then its value is stored 
in the 
^B^errorCode
 global variable. This variable is 
intended to hold a machine-readable description of the 
error in cases where such information is available; see 
the 
^B^tclvars
 manual page for information on the proper format for the 
variable. If the code argument is not present, then 
^B^errorCode
 is automatically reset to "
^B^NONE
 by the Tcl interpreter, as part of processing the error generated 
by the command. 
