# bitmaps.tcl - define some memory bitmaps that are used by the library files in
#               this directory so that we don't have to know the unix path names.
#
# Copyright (C) 1995 Allan Brighton (allan@piano.sta.sub.org)
#


proc define_bitmaps {} {
    if {[blt_bitmap exists decr_xbm]} {
	return
    }

    blt_bitmap define decr_xbm { {7 4} {
	0x7f, 0x3e, 0x1c, 0x08
    }}
    blt_bitmap define incr_xbm { {7 4} {
	0x08, 0x1c, 0x3e, 0x7f
    }}
    blt_bitmap define down_xbm { {16 16} {
	0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03,
	0xc0, 0x03, 0xc0, 0x03, 0xf8, 0x1f, 0xf8, 0x1f, 0xf0, 0x0f, 0xe0, 0x07,
	0xc0, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00
    }}
    blt_bitmap define up_xbm { {16 16} {
	0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f,
	0xf8, 0x1f, 0xf8, 0x1f, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03,
	0xc0, 0x03, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00
    }}
    blt_bitmap define left_xbm { {16 16} {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xe0, 0x00, 0xf0, 0x00,
	0xf8, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0xf8, 0x3f, 0xf0, 0x00, 0xe0, 0x00,
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    }}
    blt_bitmap define right_xbm { {16 16} {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x07, 0x00, 0x0f,
	0xfc, 0x1f, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x1f, 0x00, 0x0f, 0x00, 0x07,
	0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    }}
}

