# TableListPrint.tcl - Print Dialog Box for printing the contents of a TableList
#
# usage: TableListPrint -table $thisptr
# (where $thisptr is the handle of the TableList itcl class object)
#
# Copyright (C) 1994 Allan Brighton (allan@piano.sta.sub.org)

itcl_class TableListPrint {
    inherit PrintDialog


    # create a new instance of this class

    constructor {config} {
	PrintDialog::constructor
	
	if {$choose} {
	    pack [frame $this.options -bd 3 -relief groove] \
		-side top -fill x -expand 1 -in $this.config

	    # get and display a list of visible headings
	    set headings_ [$table info public headings -value]
	    set showing {}
	    foreach i $headings_ {
		if {[$table get_option $i Show]} {
		    lappend showing $i
		}
	    }

	    # let the user choose which columns to print
	    pack [Check $this.options.cols \
		      -text "Table Columns to print:" \
		      -layout vertical \
		      -cols 3 \
		      -choice $headings_ \
		      -value $showing] \
		-side top -fill x
	}
    }

    
    # This method is redefined here from the parent class to
    # print the contents of the TableList with specified columns
    
    method print {fd} {
	if {$choose} {
	    foreach i $headings_ {
		set save($i) [$table get_option $i Show]
	    }
	    $table set_options $headings_ Show 0
	    foreach i [$this.options.cols get] {
		$table set_option $i Show 1
	    }

	    $table calculate_format_
	    $table print $fd

	    foreach i $headings_ {
		$table set_option $i Show $save($i)
	    }
	    $table calculate_format_
	} else {
	    $table print $fd
	}
    }

    

    # -- Public variables -- 

    # handle of the TableList class that created this dialog
    # (used to access the current values there...)
    public table {}

    # flag: if true, add a Choice widget for choosing the columns to print
    public choose 1


    # -- Protected variables --
    
    # table column headings
    protected headings_
}


