# LabelText.tcl - Itcl widget for displaying a label and multi-line text
#
# Copyright (C) 1994 Allan Brighton (allan@piano.sta.sub.org)


itcl_class LabelText {
    inherit FrameWidget


    #  Get the value in the text

    method get {} {
	return [$this.text get 1.0 end]
    }
   

    # constructor: create a new LabelText widget

    constructor {config} {
	FrameWidget::constructor

	pack [label $this.label] \
	    -side $side -ipadx 1m
	pack [text $this.text -bd $bd -relief $relief] \
	    -side $side -expand 1 -fill x -padx 1m -ipadx 1m

	set initialized_ 1

	#  Explicitly handle config's that may have been ignored earlier
	foreach attr $config {
	    config -$attr [set $attr]
	}
    }

   
    # -- public variables --


    # set the text text's label
    public text {} {
	if {$initialized_} {
	    $this.label config -text $text
	}
    }

    # set the value in the text
    public value {} {
	if {$initialized_} {
	    $this.text delete 1.0 end
	    $this.text insert end $value
	}
    }


    # set the width for  displaying the label (in chars)
    public labelWidth {} {
	if {$initialized_} {
	    $this.label config -width $labelWidth
	}
    }
    
    # set the width in chars for displaying the value
    public valueWidth {} {
	if {$initialized_} {
	    $this.text config -width $valueWidth
	}
    }
    
    # set the number of lines to display for the value
    public valueHeight {} {
	if {$initialized_} {
	    $this.text config -height $valueHeight
	}
    }

    # set the font for  displaying the label
    public labelFont {} {
	if {$initialized_} {
	    $this.label config -font $labelFont
	}
    }
    
    # set the font for displaying the value
    public valueFont {} {
	if {$initialized_} {
	    $this.text config -font $valueFont
	}
    }
    
    # set the background color
    public bg {} {
	if {$initialized_} {
	    $this.text config -bg $bg
	    $this.label config -bg $bg
	}
    }
    
    # set the border width for the text window
    public bd {2} {
	if {$initialized_} {
	    $this.text config -bd $bd
	}
    }
    
    # set the text relief 
    public relief {flat} {
	if {$initialized_} {
	    $this.text config -relief $relief
	}
    }
    

    # set the label anchor (the text follows)
    public anchor {} {
	if {$initialized_} {
	    $this.label config -anchor $anchor
	}
    }
    

    # pack option: use left for horizontal orient, top for vert.
    public side {left}

    
    # -- protected vars --

    # set to 1 in constructor
    protected initialized_ 0
}

