.\" Copyright (c) 1994 Allan Brighton (allan@piano.sta.sub.org)
.so man.macros
.HS FrameWidget itcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
FrameWidget \- An [incr Tcl] Base Class for Widgets with their own Frame
.SH SYNOPSIS
.nf
\f4
itcl_class \fIMyWidget\fR {
    inherit \fBFrameWidget\fR
    constructor {config} {
        \fBFrameWidget\fR::constructor \fI?-option arg?...\fR
        ...
    }
}
\f1
.fi
.BE
.ta 4c
.SH DESCRIPTION
.PP
The \fBFrameWidget\fR itcl class creates a frame window with the same name as
the class object (\fIthis\fR) and sets up the necessary bindings, so that the Itcl
object and any descending objects are destroyed if the frame widget is destroyed. 
In addition, a number of useful \fImethods\fR are defined, for use by the derived classes. 

.SH "METHODS"
.PP
The following operations are defined in the \fBFrameWidget\fR class for use by 
derived classes:
.TP
\fBconfig\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Modify the configuration options of the widget.
\fIOption\fR may have any of the values accepted by the \fBFrameWidget\fR
constructor. This method is inherited by derived classes, so you can use \fBconfig\fR
on a derived object and specify options for that object as well.
.TP
\fBbusy \fI{ commands... }\fR
This command displays the \fIblt\fR busy cursor over the frame and its toplevel window
while evaluating the given commands within the scope of the calling class method.
Nested calls to \fBbusy\fR are allowed and errors are propagated to
the caller.

.SH AUTHOR
.TP 0
Allan Brighton - Free-lance Software Engineer (near Munich)
.sp 0
E-mail: allan@piano.sta.sub.org
.sp 0
Snail-Mail: Zaissing 3, 85643 Steinhoering, Germany
.SH SEE ALSO
FrameWidget
.SH KEYWORDS
TopLevelWidget, widget
