# Bindings.tcl - basic entry and text bindings
#
# Allan Brighton (allan@piano.sta.sub.org)


# set up some default bindings for the entry widget
# The bindings below were modofied from Tix3.6d.

proc set_entry_bindings {{w Entry}} {
    bind $w <1> {
	if {[catch {%W index sel.first}] == 0} {
	    %W select from end
	    %W select to   end
	}
	%W icursor @%x
	%W select from @%x
	if {[lindex [%W config -state] 4] == "normal"} {focus %W}
    }
    bind $w <B1-Motion> {
	%W select to @%x
	%W icursor @%x
    }
    bind $w <Shift-1> {
	%W select adjust @%x
    }
    bind $w <Shift-B1-Motion> {
	%W select to @%x
    }
    bind $w <2> {
	catch {
	    %W icursor @%x
	    %W insert insert [selection get]
	    tk_entrySeeCaret %W
	}
    }
    bind $w <KeyPress> {
	if {"%A" != ""} {
	    if {[catch {%W index sel.first}] == 0} {
		%W delete sel.first sel.last
	    }
	    %W insert insert %A
	    tk_entrySeeCaret %W
	}
    }
    bind $w <Delete>    {
	if [catch {%W index sel.first}] {
	    tk_entryBackspace %W
	} else {
	    %W delete sel.first sel.last
	}
	tk_entrySeeCaret %W
    }

    bind $w <Control-d>    {
	if [catch {%W index sel.first}] {
	    %W delete [%W index insert]
	} else {
	    %W delete sel.first sel.last
	}
	tk_entrySeeCaret %W
    }

    bind $w <BackSpace> {
	if [catch {%W index sel.first}] {
	    tk_entryBackspace %W
	} else {
	    %W delete sel.first sel.last
	}
	tk_entrySeeCaret %W
    }

    bind $w <Control-h> {
	if [catch {%W index sel.first}] {
	    tk_entryBackspace %W
	} else {
	    %W delete sel.first sel.last
	}
	tk_entrySeeCaret %W
    }

    bind $w <Right>     {%W icursor [expr [%W index insert]+1]; tk_entrySeeCaret %W}
    bind $w <Control-f> {%W icursor [expr [%W index insert]+1]; tk_entrySeeCaret %W}
    bind $w <Left>      {%W icursor [expr [%W index insert]-1]; tk_entrySeeCaret %W}
    bind $w <Control-b> {%W icursor [expr [%W index insert]-1]; tk_entrySeeCaret %W}
    bind $w <Home>      {%W icursor 0; tk_entrySeeCaret %W}
    bind $w <Control-a> {%W icursor 0; tk_entrySeeCaret %W}
    bind $w <End>       {%W icursor end; tk_entrySeeCaret %W}
    bind $w <Control-e> {%W icursor end; tk_entrySeeCaret %W}
    bind $w <Control-k> {%W delete insert end; tk_entrySeeCaret %W}
}


# set up some default bindings for the text widget
# The bindings below were modofied from Tix3.6d.

proc set_text_bindings {{w Text}} {
    bind $w <1> {
	%W tag remove sel 0.0 end
	set tk_priv(selectMode) char
	%W mark set insert @%x,%y
	%W mark set anchor insert
	if {[lindex [%W config -state] 4] == "normal"} {focus %W}
    }
    bind $w <Double-1> {
	set tk_priv(selectMode) word
	%W mark set insert "@%x,%y wordstart"
	tk_textSelectTo %W insert
    }
    bind $w <Triple-1> {
	set tk_priv(selectMode) line
	%W mark set insert "@%x,%y linestart"
	tk_textSelectTo %W insert
    }
    bind $w <B1-Motion> {
	tk_textSelectTo %W @%x,%y
	%W mark set insert @%x,%y
    }
    bind $w <Shift-1> {
	tk_textResetAnchor %W @%x,%y
	tk_textSelectTo %W @%x,%y
    }
    bind $w <Shift-B1-Motion> {
	tk_textSelectTo %W @%x,%y
	%W mark set insert @%x,%y
    }
    bind $w <2> {
	catch {
	    %W mark set insert @%x,%y
	    %W insert insert [selection get]
	    %W mark set insert @%x,%y
	    %W yview -pickplace insert
	}
    }
    bind $w <Left> {
	%W mark set insert insert-1c
	%W yview -pickplace insert
    }
    bind $w <Right> {
	%W mark set insert insert+1c
	%W yview -pickplace insert
    }
    bind $w <Up> {
	%W mark set insert insert-1l
	%W yview -pickplace insert
    }
    bind $w <Down> {
	%W mark set insert insert+1l
	%W yview -pickplace insert
    }

    bind $w <Control-v> {
	%W mark set insert end
	%W yview -pickplace insert
    }

    bind $w <Meta-v> {
	%W mark set insert 1.0
	%W yview -pickplace insert
    }

    bind $w <Return> {
	catch {
	    if {[%W tag ranges sel] != {}} {
		eval %W delete [%W tag ranges sel]
	    }
	}
	%W insert insert \n
	%W yview -pickplace insert
    }

    bind $w <Control-d> {
	if {[%W tag ranges sel] != {}} {
	    eval %W delete [%W tag ranges sel]
	} else {
	    %W delete insert
	}
	%W yview -pickplace insert
    }

    bind $w <Delete> {
	if {[%W tag ranges sel] != {}} {
	    eval %W delete [%W tag ranges sel]
	} else {
	    tk_textBackspace %W
	}
	%W yview -pickplace insert
    }

    bind $w <BackSpace> {
	if {[%W tag ranges sel] != {}} {
	    eval %W delete [%W tag ranges sel]
	} else {
	    tk_textBackspace %W
	}
	%W yview -pickplace insert
    }

    bind $w <Control-h> {
	if {[%W tag ranges sel] != {}} {
	    eval %W delete [%W tag ranges sel]
	} else {
	    tk_textBackspace %W
	}
	%W yview -pickplace insert
    }

    bind $w <Control-w> {
	if {[%W tag ranges sel] != {}} {
	    eval %W delete [%W tag ranges sel]
	}
	%W yview -pickplace insert
    }

    bind $w <Control-a> {
	%W mark set insert {insert linestart}
	%W yview -pickplace insert
    }

    bind $w <Control-e> {
	%W mark set insert {insert lineend}
	%W yview -pickplace insert
    }

    bind $w <Control-k> {
	if {"[%W index {insert lineend}]" == "[%W index insert]"} {
	    %W delete insert {insert+1line}
	} else {
	    %W delete insert {insert lineend}
	}
	%W yview -pickplace insert
    }

    bind $w <KeyPress> {
	if {"%A" != "" && [ctype print "%A"]} {
	    catch {
		if {[%W tag ranges sel] != {}} {
		    eval %W delete [%W tag ranges sel]
		}
	    }
	    %W insert insert %A
	    %W yview -pickplace insert
	}
    }
}


# set all the default bindings

proc set_default_bindings {} {
    set_entry_bindings
    set_text_bindings
}
