#!/usr/bin/wish -f
#
# This script demonstrates the various widgets provided by Tk,
# along with many of the features of the Tk toolkit.  This file
# only contains code to generate the main window for the
# application, which invokes individual demonstrations.  The
# code for the actual demonstrations is contained in separate
# ".tcl" files is this directory, which are auto-loaded by Tcl
# when they are needed.  To find the code for a particular
# demo, look below for the procedure that's invoked by its menu
# entry, then grep for the file that contains the procedure
# definition.

set auto_path ". $auto_path"
#set auto_path "/usr/lib $tk_library/demos /usr/lib/tkX/3.6b/help/tk/control ."
#set auto_path "."
set fall_set 0 
set tcl_interactive 1
wm title . "TOP Steuer-Profi"

#-------------------------------------------------------
# The code below create the main window, consisting of a
# menu bar and a message explaining the basic operation
# of the program.
#-------------------------------------------------------

frame .menu -relief raised -borderwidth 1
message .msg -font -Adobe-times-medium-r-normal--*-180* -relief raised -width 500 \
-borderwidth 1 -text \
   "Sie arbeiten jetzt mit der Sharewareversion von Steuer-Profi \
    \n\t(c) Kriegl-Soft, Erfurter Str. 8, 80993 Mnchen\
      \n\t\tT./Fax:089/1411201 \
    \nFr nur DM 42,- Erhalten Sie die Vollversion von Steuer-Profi\
     mit einem 60 seitigem gedruckten Handbuch und reines Gewissen. \
     Steuer-Profi verlassen mit dem Menpunkt Exit unter dem \
     Hauptmen/Start.          \
     \n\
     Die Unkenntnis der Steuergesetze befreit nicht \
     von der Pflicht, Steuer zu zahlen. Die Kenntnis \
     aber hufig.\tBaron Rotschild"

pack .menu -side top -fill x
pack .msg -side bottom -expand yes -fill both

#-------------------------------------------------------
# The code below creates all the menus, which invoke procedures
# to create particular demonstrations of various widgets.
#-------------------------------------------------------

#source stForm.tcl
source FSBox.tcl
source helpf2.tk
source gooddate.tk
source calc.tk

# The procedure below is invoked in response to tabs in the entry
# windows.  It moves the focus to the next window in the tab list.
# Arguments:
#
# list -	Ordered list of windows to receive focus

proc Tab {list} {
    set i [lsearch $list [focus]]
    if {$i < 0} {
	set i 0
    } else {
	incr i
	if {$i >= [llength $list]} {
	    set i 0
	}
    }
    focus [lindex $list $i]
}
# Position a dialog box at a reasonable place on the screen.

proc dpos w {
    wm geometry $w +100+150
}
# The utility procedure below loads a file into a text widget,
# discarding the previous contents of the widget. Tags for the
# old widget are not affected, however.
# Arguments:
#
# w -           The window into which to load the file.  Must be a
#               text widget.
# file -        The name of the file to load.  Must be readable.

proc TextLoadFile {w file} {
   set f [open $file]
   $w delete 1.0 end
   while {![eof $f]} {
       $w insert end [read $f 10000]
   }
   close $f
}

proc show_file {{name steuer.aus} {w .basic}} {
global global_ausgabe
   if {$global_ausgabe == 2 || $global_ausgabe == 6 } {
      catch {destroy $w}
      toplevel $w
      dpos $w
      wm title $w "Ausgabe der Ergebnisse"
      wm iconname $w "Ausgabe"
      button $w.ok -text OK -command "destroy $w"
      text $w.t -relief raised -bd 2 -yscrollcommand "$w.s set" -setgrid true
      scrollbar $w.s -relief flat -command "$w.t yview"
      pack $w.ok -side bottom -fill x
      pack $w.s -side right -fill y
      pack $w.t -expand yes -fill both
      TextLoadFile $w.t $name
      $w.t mark set insert 0.0
      bind $w <Any-Enter> "focus $w.t"
      tkwait window $w
      exec rm $name
   }
}
proc call_FSBox {{mywindow .menu}} {
global fsBox
global template
     $mywindow config -cursor {watch red white}
     set result 1
     while { $result != 0 } {
       FSBox *.s94*
       if [regexp {[.]s94} $fsBox(name)] {
           set result [linux_beolvas   $fsBox(path) $fsBox(name)]
           if { $result == 0 } {
             linux_berechne
             show_file $template .menu.tyuk
             init_command "0"
           } else {
             mkAlarm $result .menu.tyuk1
             tkwait window .menu.tyuk1
           }
       } elseif { $fsBox(name) == "" } {
          set result 0
       } else {     
          mkAlarm "Datei $fsBox(name) keine Steuerdatei" .menu.tyuk1
          tkwait window .menu.tyuk1
          set result 0
       }
     }
}
proc call_aend {} {
global fsBox
global template
     set result 1
     while { $result != 0 } {
       FSBox *.s94* "Datei zu ndern" 
       if [regexp {[.]s94} $fsBox(name)] {
           set result [linux_beolvas   $fsBox(path) $fsBox(name)]
           if { $result == 0 } {
               set filename $fsBox(name)
               staend_scr .menu.tyuk
               tkwait window .menu.tyuk
               linux_alles_berechnen
               linux_ausdr
               show_file $template .menu.tyuk
               ausdr_file $filename
               init_command "0"
           } else {
             mkAlarm $result .menu.tyuk1
             tkwait window .menu.tyuk1
           }
       } elseif { $fsBox(name) == "" } {
          set result 0
       } else {     
          mkAlarm "Datei $fsBox(name) keine Steuerdatei" .menu.tyuk1
          tkwait window .menu.tyuk1
          set result 0
       }
     }
}
proc call_neu {} {
global fsBox
global template
     staend_scr .tyuk
     tkwait window .tyuk
     linux_alles_berechnen
     linux_ausdr
     show_file $template .tyuk

     ausdr_file
     init_command "0"
}

proc fall_best {} {
global fsBox
global fall_set 
#global template
     set result 1
     while { $result != 0 } {
       FSBox *.s94*
       if [regexp {[.]s94} $fsBox(name)] {
           set result [linux_beolvas   $fsBox(path) $fsBox(name)]
           if { $result == 0 } {
             linux_alles_berechnen
             set fall_set "1"
#            exec rm $template
           } else {
             mkAlarm $result .menu.tyuk1
             tkwait window .menu.tyuk1
           }
       } elseif { $fsBox(name)  == "" } {
            set result 0
       } else {     
          mkAlarm "Datei $fsBox(name) keine Steuerdatei" .menu.tyuk1
          tkwait window .menu.tyuk1
          set result 0
       }
     }
}
proc druck_glob { {msgein "msg"} { head "head"} {nrmax 2} {name "a"} } {
global fall_set 
global what_to_do
     if { $fall_set == "1" } {
       for {set i 1} {$i < $nrmax} {incr i} {
        set msg "Soll $msgein Seite $i gedruckt werden?" 
        mkDruck $msg $head .tyuk
        tkwait window .tyuk
        if { $what_to_do == 1 } {
            set formular "$name[expr $i - 1]"
            print_form $formular
        }
        if { $what_to_do == 2 } {
            #puts "Ich drucke nicht"
        }
        if { $what_to_do == 3 } {
            #puts "Ich hre auf"
            break
        }
      }
     }
     if { $fall_set == "0" } {
        mkAlarm "Zuerst mssen Sie einen Fall bestimmen" .menu.tyukalarm
        tkwait window .menu.tyukalarm
     }
}
proc druck_mant {} {
    druck_glob "der Mantelbogen" "Mantelbogen"  5  "a"
}
proc druck_nsem {} {
    druck_glob "Nichtselbst/Em" "Nichtselbst/Em"  3  "n"
#        mkAlarm "Alarm test - Ich teste den Alarm jetzt" .tyuk
#        tkwait window .tyuk
}
proc druck_nsef {} {
    druck_glob "Nichtselbst/Ef" "Nichtselbst/Ef"  3  "m"
}
proc druck_vv {} {
    druck_glob "Verm/Verp" "Verm/Verp"  3  "v"
}
proc druck_fw {} {
    druck_glob "FW" "FW"  3  "f"
}
proc druck_kso {} {
    druck_glob "KSO" "KSO"  3  "k"
}
proc druck_gse {} {
    druck_glob "GSE" "GSE"  3  "g"
}
proc druck_luf {} {
    druck_glob "LUF" "LUF"  2  "l"
}
proc conf_it {} {
    config_first
    stconf_scr .tyuk
    tkwait window .tyuk
    config_last
}
proc vorsorge {} {
global t_hoechst 
global t_pausch
global t_rest
    vors_vorbereitung
    stsvors_scr .tyuk
    tkwait window .tyuk
}
proc ermittel {} {
    ermitt_vorbereitung
    ststerm_scr .tyuk
    tkwait window .tyuk
    ermitt_berechnung 3
}
proc anl_druck {} {
    stanl_scr .tyuk
    tkwait window .tyuk
}
proc call_konv {} {
global fsBox
     set result 1
     while { $result != 0 } {
       FSBox *.s93*
       if [regexp {[.]s93} $fsBox(name)] {
          regsub {[.]s93}  $fsBox(name) {.s94} neufile
          exec cp $fsBox(name) $neufile
          set result 0
       } elseif { $fsBox(name) == "" } {
          set result 0
       } else {     
          mkAlarm "Datei $fsBox(name) keine Steuerdatei" .menu.tyuk1
          tkwait window .menu.tyuk1
          #set result 0
       }
     }
}
proc do_kiir {{path} {filename} } {
    global answer
    set kiirta 1
    set result 5
    set yesno nein 
    while { $result != 0 } {
      set result [linux_kiir  $path $filename $yesno ]
       if { $result == 2 } {
           set answer -1
           mk3Ask "Datei $path/$filename existiert bereits - berschreiben?" .menu.tyuk1
           tkwait window .menu.tyuk1
           if { $answer == 1 } {
               set yesno ja 
           } else {
               set result 0
           }
       } elseif { $result == 3 } {
          mkAlarm "Kann Datei $path/$filename nicht erffnen zum Schreiben" .menu.tyuk1
          tkwait window .menu.tyuk1
          set result 0
       } elseif { $result == 4 } {
          mkAlarm "Kann Datei $path/$filename nicht schlieen" .menu.tyuk1
          tkwait window .menu.tyuk1
          set result 0
       } elseif { $result != 0 } {
          mkAlarm "Datei $path/$filename wird nicht abgespeichert" .menu.tyuk1
          tkwait window .menu.tyuk1
          set result 0
          set kiirta 0
       } else {
          set kiirta 0
       }
    }
    return $kiirta
}
proc ausdr_file { {filename ""}} {
global fsBox 
     set result1 1
     while { $result1 != 0 } {
        FSBox *.s94* "In Datei Schreiben" $filename
        if { $fsBox(name)  == ""  && $fsBox(empty)  == 1 } {
           mkAlarm "Bitte eine Datei angeben" .menu.tyuk1
           tkwait window .menu.tyuk1
        } elseif { $fsBox(name)  == "" } {
           set result1 0
        } elseif [regexp {[.]s94} $fsBox(name)] {
           set result1 [do_kiir $fsBox(path) $fsBox(name) ]
        } else {
           set filename $fsBox(name).s94
           set result1 [do_kiir $fsBox(path) $filename ]
        }
     }
}
proc loesche_stdat {} {
    global answer
    mk3Ask "Steuerdateien lschen? (ST*\ \ sT*\ \  steuer.ein \ \  steuer.aus)" .menu.tyuk1
    tkwait window .menu.tyuk1
    if { $answer == 1 } {
        catch {eval exec rm [glob ST*]}
        catch {eval exec rm [glob sT*]}
        catch {exec rm steuer.ein}
        catch {exec rm steuer.aus}
        mkAlarm "Steuerdateien wurden gelscht" .menu.tyuk3 "Info"
        tkwait window .menu.tyuk3
    }
}

menubutton .menu.info -text "Info" -menu  .menu.info.m \
    -underline 0
menu .menu.info.m
.menu.info.m add command -label "ber" -command "mkInfo" \
   -underline 0
menubutton .menu.start -text "Start" -menu .menu.start.m \
	-underline 0
menu .menu.start.m
.menu.start.m add command -label "Bearbeiten..." -command {call_FSBox .menu.start.m} -underline 0
.menu.start.m add command -label "ndern..." -command {call_aend} -underline 0
.menu.start.m add command -label "Neue Daten..." -command {call_neu} \
    -underline 0
.menu.start.m add command -label "Konversion..." -command {call_konv} \
    -underline 0
.menu.start.m add command -label "Exit" -command "destroy ." -underline 0

menubutton .menu.ausgabe -text "Ausgabe" -menu .menu.ausgabe.m \
	-underline 0
menu .menu.ausgabe.m
.menu.ausgabe.m add cascade -label "Ausgabedaten auf:" -menu .menu.ausgabe.m.radio \
    -underline 0
.menu.ausgabe.m add cascade -label "Eingabedaten auf:" -menu .menu.ausgabe.m.radio1 \
    -underline 0

menu .menu.ausgabe.m.radio
.menu.ausgabe.m.radio add radio -label "Bildschirm" -variable \
          global_ausgabe -value 2
.menu.ausgabe.m.radio add radio -label "Drucker" -variable \
          global_ausgabe -value 3
.menu.ausgabe.m.radio add radio -label "Datei \"steuer.aus\"" \
    -variable global_ausgabe -value 4

menu .menu.ausgabe.m.radio1
.menu.ausgabe.m.radio1 add radio -label "Bildschirm" -variable \
          global_ausgabe -value 6
.menu.ausgabe.m.radio1 add radio -label "Drucker" -variable \
          global_ausgabe -value 7
.menu.ausgabe.m.radio1 add radio -label "Datei \"steuer.ein\"" \
    -variable global_ausgabe -value 8


menubutton .menu.formular -text "Formular" -menu .menu.formular.m -underline 0
menu .menu.formular.m
.menu.formular.m add command -label "Fall bestimmen" -command {fall_best} \
    -underline 0
.menu.formular.m add command -label "Antrag/Mantelbogen" -command {druck_mant} \
    -underline 0 
.menu.formular.m add command -label "Nichtselbst/Em" -command {druck_nsem}  \
    -underline 0 
.menu.formular.m add command -label "Nichtselbst/Ef" -command {druck_nsef}  \
    -underline 1 
.menu.formular.m add command -label "Kapital/Sonst." -command {druck_kso}   \
    -underline 0 
.menu.formular.m add command -label "Vermietung/Verp." -command {druck_vv}    \
    -underline 0
.menu.formular.m add command -label "Frderung des W." -command {druck_fw}    \
    -underline 0 
.menu.formular.m add command -label "Gewerbe/Selbst." -command {druck_gse}  \
    -underline 0 
.menu.formular.m add command -label "Land u. Forstw." -command {druck_luf}  \
    -underline 0 

menubutton .menu.option -text "Option" -menu .menu.option.m \
	-underline 0
menu .menu.option.m
.menu.option.m add command -label "Ermittlung..." -command {ermittel}   -underline 0
.menu.option.m add command -label "Vorsorge..." -command {vorsorge} -underline 0
.menu.option.m add command -label "Konfigurieren..." -command {conf_it} -underline 0
.menu.option.m add command -label "Anlagen..." -command {anl_druck} -underline 0
.menu.option.m add command -label "Lschen..." -command {loesche_stdat} -underline 0

menubutton .menu.hilfe -text "Hilfe" -menu .menu.hilfe.m -underline 0
menu .menu.hilfe.m
.menu.hilfe.m add command -label "Hilfe" -command {Help 0} -underline 0

#source sttest.tcl

#bind all   <Key-H>   {mkVScale}
bind all   <Key-F>   {-menu .menu.formular.m}


pack .menu.info .menu.start .menu.ausgabe .menu.formular .menu.option \
	.menu.hilfe  -side left

tk_menuBar .menu .menu.info .menu.start .menu.ausgabe .menu.formular \
	.menu.option .menu.hilfe 

#pack .menu.info .menu.start .menu.ausgabe .menu.formular .menu.option \
#	.menu.hilfe .menu.test  .menu.test1 .menu.test2 \
#	.menu.test3 .menu.test4 .menu.test5 -side left

#	tk_menuBar .menu .menu.info .menu.start .menu.ausgabe .menu.formular \
#	.menu.option .menu.hilfe .menu.test .menu.test1 .menu.test2 \
#	.menu.test3 .menu.test4 .menu.test5

# Set up for keyboard-based menu traversal

bind . <Any-FocusIn> {
    if {("%d" == "NotifyVirtual") && ("%m" == "NotifyNormal")} {
	focus .menu
    }
}
bind all <F3> {toplevel .calc; ENTRY:setState newNumber; BUILD:calcWin .calc} 

