#
# $Id: simplelist.tcl,v 1.4 1995/06/11 08:40:10 sls Exp $
#
# A listbox wrapped in a frame with a scrollbar
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

document_title simplelist "a simple list widget" {}

if [string length [info commands option]] {
    option add *Simplelist*padX 0
    option add *Simplelist*padY 0
}

document_widget simplelist {
    creates a list with a scrollbar and optional title.
}
widget simplelist {
    document_param title "Specifies the title to display."
    param title ""
    document_param selectmode "Same as #listbox#'s #-selectmode#."
    param selectmode single
    method create {} {
	set w $self
	$w config -relief raised -bd 2
	label $w.title -anchor w -bd 0
	pack $w.title -in $w -side top -fill x
	scrollbar $w.sb -command "$w.list yview"
	listbox $w.list -yscroll "$w.sb set" -relief sunken -bd 2
	pack $w.sb -in $w -side right -fill y
	pack $w.list -in $w -side right -fill both -expand 1
    }
    method reconfig {} {
	set w $self
	$w.list config -selectmode $slot(selectmode)
	$w.title config -text $slot(title)
    }
    document_method get "Returns a list containing current selection, or {}."
    method get {} {
	set result ""
	foreach s [$self.list curselection] {
	    lappend result [$self.list get $s]
	}
	return $result
    }
    document_method list "Passes its arguments to the underlying #listbox#."
    method list args {
	uplevel [concat $self.list $args]
    }
    document_method list "Calls #bind# with its arguments on the underlying #listbox#."
    method bind {event args} {
	uplevel [concat [list bind $self.list $event] $args]
    }
}
