#
# $Id: columns.tcl,v 1.4 1995/07/04 20:25:47 sls Exp $
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

document_title columns "pack widgets into columns" {
}

document_widget columns {
    packs widgets into columns.
}
widget columns {
    document_param columns {
	Specifies the number of columns.  Each column is a Tk #frame#.
    }
    param columns 1
    document_param columnstyle {
	Specifies options that should be passed to #frame# when the
	each column is created.
    }
    param columnstyle {}
    param columnpack {}
    member update_pending 0
    method create {} {
    }
    method reconfig {} {
	set slaves [pack slaves $self]
	foreach slave $slaves {
	    pack forget $slave
	    destroy $slave
	}
	for {set i 0} {$i < $slot(columns)} {incr i} {
	    if ![info exists slot(packstyle.$i)] {
		set slot(packstyle.$i) "-side top -fill x"
	    }
	    if ![info exists slot(framepack.$i)] {
		set slot(framepack.$i) "-side left -fill x -expand 1 -anchor nw"
	    }
	    set f [eval frame $self.col$i $slot(columnstyle)]
	    eval pack $f $slot(framepack.$i)
	    if ![info exists slot(column.$i)] {
		set slot(column.$i) ""
	    }
	    foreach w $slot(column.$i) {
		eval pack $w -in $f $slot(packstyle.$i)
		raise $w
	    }
	}
	set slot(update_pending) 0
    }
    method packstyle {n args} {
	if ![llength $args] {
	    return $slot(packstyle.$n)
	}
	set slot(packstyle.$n) $args
	$self mark_for_update
    }
    method framepack {n args} {
	if ![llength $args] {
	    return $slot(framepack.$n)
	}
	set slot(framepack.$n) $args
	$self mark_for_update
    }
    document_method append {
	appends the widgets in `args' to column `n'.
    }
    method append {n args} {
	foreach w $args {
	    lappend slot(column.$n) $w
	    $self mark_for_update
	}
    }
    method mark_for_update {} {
	if !$slot(update_pending) {
	    set slot(update_pending) 1
	    after 0 $self reconfig
	}
    }
}
