#
# $Id: profile.tcl,v 1.4 1995/06/11 08:41:23 sls Exp $
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

document_title profile "simple profiling" {
    These procedures do simple-minded profiling of Tcl code.  Since there
    is considerable overhead in this code, it should
    only be used to watch large chunks.
}

set profile_priv(on) 0
set profile_priv(procs) ""

document_proc profile_on {
    turns on profiling of selected procs.
}
proc profile_on {} {
    global profile_priv
    set profile_priv(on) 1
}

document_proc profile_off {
    turns off profiling of selected procs.
}
proc profile_off {} {
    global profile_priv
    set profile_priv(on) 0
}

document_proc profile_watchprocs {
    starts counting time spent in each proc in `args' if profiling is
    on.
}
proc profile_watchprocs {args} {
    global profile_priv
    if !$profile_priv(on) return
    foreach proc $args {
	rename $proc %%$proc
	proc $proc args "profile_accumulate $proc \$args"
	set profile_priv($proc/ms) 0
	set profile_priv($proc/calls) 0
	lappend profile_priv(procs) $proc
    }
}

proc profile_accumulate {proc a} {
    global profile_priv
    set ms [expr [lindex [time {set result [uplevel [concat %%$proc $a]]}] 0] / 1000.0]
    set profile_priv($proc/ms) [expr $profile_priv($proc/ms) + $ms]
    incr profile_priv($proc/calls)
    return $result
}

document_proc profile_show {
    displays the time spent in the procs being watched.
}
proc profile_show {} {
    global profile_priv
    puts "------------------------------------------------------------"
    foreach proc $profile_priv(procs) {
	if $profile_priv($proc/calls) {
	    puts "$proc : $profile_priv($proc/ms) ms total ($profile_priv($proc/calls) calls, [expr 1.0 * $profile_priv($proc/ms) / $profile_priv($proc/calls)] ms/call)"
	} else {
	    puts "$proc : no calls"
	}
    }
    puts "------------------------------------------------------------"
}

document_proc profile_reset {
    resets the time counters for all procs being watched.
}
proc profile_reset {} {
    global profile_priv
    foreach proc $profile_priv(procs) {
	set profile_priv($proc/ms) 0
	set profile_priv($proc/calls) 0
    }
}
