#
# $Id: msg.tcl,v 1.5 1995/03/21 03:49:06 sls Exp $
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# Messages, warnings, etc.
#

document_title msg "print messages and warnings" {

    These procedures print messages and warnings.  Each message has a
    severity level which defaults to 0.  A message is printed if its
    severity is equal to or greater than the current minimum level.
    The minimum level starts out at 100.

}

set msg_priv(level) 100
set msg_priv(bs) "\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b"
set msg_priv(space) "                                                                                "
set msg_priv(fp) stderr

document_proc msg_verbose {
    sets the current verbosity level.  `level' defaults to 0.
}
proc msg_verbose {{level 0}} {
    global msg_priv
    set msg_priv(level) $level
}

document_proc msg_quiet {
    sets the minimum severity level to 100.
}
proc msg_quiet {} {
    global msg_priv
    set msg_priv(level) 100
}

document_proc msg_set_sink {
    sets the current msg sink to `filehandle'.
}
proc msg_set_sink filehandle {
    global msg_priv
    set msg_priv(fp) $filehandle
}

document_proc msg {
    prints `m' on the current msg sink if `level' is >= the current level.  `level'
    defaults to 0.
}
proc msg {m {level 0}} {
    global msg_priv
    if {$level >= $msg_priv(level)} {
	puts $msg_priv(fp) "### $m"
    }
}

document_proc msg_nh {
    prints `m' like #msg#, but without the hash marks preceeding `m'.
}
proc msg_nh {m {level 1}} {
    global msg_priv
    if {$level >= $msg_priv(level)} {
	puts $msg_priv(fp) "$m"
    }
}

document_proc msg_dnl {
    prints `m' like #msg#, but without a trailing newline.
}
proc msg_dnl {m {level 0}} {
    global msg_priv
    if {$level >= $msg_priv(level)} {
	puts -nonewline $msg_priv(fp) "### $m"
    }
}

document_proc msg_dnl_nh {
    prints `m' like #msg_nh#, but without a trailing newline.
}
proc msg_dnl_nh {m {level 0}} {
    global msg_priv
    if {$level >= $msg_priv(level)} {
	puts -nonewline $msg_priv(fp) "$m"
    }
}

document_proc msg_bs {
    prints `m' (like #msg_nh#) followed by spaces out to column 79, then
    backspaces back to column 0.  `level' defaults to 0.
}
proc msg_bs {msg {level 0}} {
    global msg_priv
    if {$level >= $msg_priv(level)} {
	set len [string length $msg]
	if {$len > 79} {
	    set len 79
	    set msg [string range $msg 0 78]
	}
	puts -nonewline $msg_priv(fp) $msg
	puts -nonewline $msg_priv(fp) [string range $msg_priv(space) 0 [expr 79 - $len]]
	puts -nonewline $msg_priv(fp) [string range $msg_priv(bs) 0 79]
	flush $msg_priv(fp)
    }
}

document_proc warning {
    unconditionally prints `msg' on the current msg sink.
}
proc warning msg {
    global msg_priv
    puts $msg_priv(fp) "### Warning! $msg"
}
