#
# $Id: bag.tcl,v 1.3 1995/03/21 03:47:48 sls Exp $
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# Define a "bag" of code fragments that can be selectively run later.
#
# bag_priv(current) -- current bag being defined
# bag_priv(<bag name>/items) -- items in <bag name>
# bag_priv(<bag name>/<item name>) -- code fragment corresponding to <item name>
#

document_title bag "define and call \"bag\"s of code fragments" {
    A bag is a named collection of Tcl code.
}

document_proc bag {
    creates a new empty bag with name `name' and evals `body'.  `body'
    typically contains a sequence of #bag_item#'s.
}
proc bag {name body} {
    global bag_priv
    set bag_priv(current) $name
    set bag_priv($name/items) {}
    uplevel $body
}

document_proc bag_item {
    defines a new bag item `name'.  The order of bag items is important,
    bag items are evaluated in order of definition.
}
proc bag_item {name body} {
    global bag_priv
    lappend bag_priv($bag_priv(current)/items) $name
    set bag_priv($bag_priv(current)/$name) $body
}

document_proc run_bag {
    runs the bag named `name'.  #run_bag# works by building a list of
    bag items to eval, and then evaluating them in sequence.
    It builds the list by looking for flags in `args'.
    #-all# sets the list to all the bag
    items.  #-except# `itemName' deletes `itemName' from the list.
    #-until# `itemName' removes all items after `itemName'.
    #-after# `itemName' removes all items before and including `itemName'.
    #-start# `itemName' removes all items before `itemName'.
    #run_bag# then appends any named items in `args' to the list.
}
proc run_bag {name args} {
    global bag_priv
    set exception ""
    set items {}
    while {[string index [set first [lindex $args 0]] 0] == "-"} {
	set second [lindex $args 1]
	if ![string compare $first "-all"] {
	    set items $bag_priv($name/items)
	    set n 1
	} elseif {![string compare $first "-except"]} {
	    set i [lsearch $items $second]
	    set tmp [lrange $items 0 [expr $i - 1]]
	    set items [concat $tmp [lrange $items [expr $i + 1] end]]
	    set n 2
	} elseif {![string compare $first "-until"]} {
	    set i [lsearch $items $second]
	    set items [lrange $items 0 [expr $i - 1]]
	    set n 2
	} elseif {![string compare $first "-after"]} {
	    set i [lsearch $items $second]
	    set items [lrange $items [expr $i + 1] end]
	    set n 2
	} elseif {![string compare $first "-start"]} {
	    set i [lsearch $items $second]
	    set items [lrange $items $i end]
	    set n 2
	} else {
	    break
	}
	set args [lrange $args $n end]
    }
    set items [concat $items $args]
    foreach item $items {
	uplevel $bag_priv($name/$item)
    }
}
