/* tkInterfaceStyle.c
 * Fashioned by Ian Wilkinson.
 * Inception was Wed Jun 22 19:25:39 BST 1994.
 *
 * My History:
 */

#include <tcl.h>
#include <tk.h>

#ifdef	SYS5
#define	index	strchr
#define	rindex	strrchr
#endif

extern      Tcl_Interp *unrestricted_interp;
extern char *index();

static In_Mkwindow=0;

/* The following implements a restricted interface to "toplevel" */
MkWindow_Cmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
    static int WindowCount=0;
    char winname[25], *newargv[3], *winnum;
    int resultcode;

    ++In_Mkwindow;
    winnum = Tcl_GetVar(interp, "WinCtr", TCL_GLOBAL_ONLY);
    resultcode = atoi(winnum) + 1;
    sprintf(winname, "%d", resultcode);
    Tcl_SetVar(interp, "WinCtr", winname, TCL_GLOBAL_ONLY);
    sprintf(winname, ".win%d", resultcode);
    newargv[0] = "toplevel";
    newargv[1] = winname;
    newargv[2] = NULL;
    /* The next line is the equivalent of "toplevel $winname", except that the restricted interpreter has mkwindow INSTEAD of toplevel */
    Tk_FrameCmd(clientData, interp, 2, newargv);
    resultcode = Tcl_VarEval(interp, "wm title ", winname, " {Safe-Tcl window ", winname, "}; button ", winname, ".sAFEBUTT -text {>>> Untrusted program running in Safe-Tcl Interpreter <<<} -command safehelp; catch \"", winname, ".sAFEBUTT configure -bg red -fg yellow -activebackground yellow -activeforeground red\" ; frame ", winname, ".f; pack append ", winname, " ", winname, ".sAFEBUTT {top} ", winname, ".f {top expand fill}", " ; proc ", winname, ".sAFEBUTT {cmd args} {safehelp $cmd $args}", NULL);
    if (resultcode == TCL_OK) {
        strcat(winname, ".f");
        Tcl_SetResult(interp, winname, TCL_VOLATILE);
    }
    --In_Mkwindow;
    return(resultcode);
}

/* The following is copied from Tk_DestroyCmd, but catches our window decorations */
int
SafeTcl_DestroyCmd(clientData, interp, argc, argv)
    ClientData clientData;		/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{
    Tk_Window window;
    Tk_Window tkwin = (Tk_Window) clientData;
    int i, len;
    char *nm;

    for (i = 1; i < argc; i++) {
        if (IsCriticalWindow(argv[i])) {
            Tcl_AppendResult(interp, "This program is attempting to use 'destroy' to subvert Safe-Tcl window decorations!", (char *) NULL);
            return TCL_ERROR;
        }
        len = strlen(argv[i]);
        if (!strncmp(argv[i], ".win", 4)
             && argv[i][len-1] == 'f'
             && argv[i][len-2] == '.'
             && index(argv[i]+1, '.') == argv[i]+len-2) {
            /* A pseudo-top-level window */
            argv[i][len-2] = '\0';
        }
	window = Tk_NameToWindow(interp, argv[i], tkwin);
	if (window == NULL) {
	    return TCL_ERROR;
	}
	Tk_DestroyWindow(window);
    }
    return TCL_OK;
}

static int 
IsCriticalWindow(nm)
char *nm;
{
    int len;

    if (!nm) return(0);
    if (!strcmp(nm, ".")) return(1);
    len = strlen(nm);
    if (len <= 10) return(0);
    if (!strcmp((nm+len-9),".sAFEBUTT")
         && (index(nm+1, '.') == nm+len-9)) {
        return(1);
    }
    return(0);
}
    

SafeTcl_PackCmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
    if (!In_Mkwindow && (IsCriticalWindow(argv[2]) || (argc > 3 && IsCriticalWindow(argv[3])))) {
        Tcl_AppendResult(interp, "This program is attempting to use pack to subvert Safe-Tcl window decorations!", (char *) NULL);
        return TCL_ERROR;
    }
    return Tk_PackCmd(clientData, interp, argc, argv);
}

int
SafeTcl_WmCmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
    if (argc < 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"",
                         argv[0], " option window ?arg ...?\"", (char *) NULL);
       return TCL_ERROR;
    }
    if (strncmp(argv[1], "overrideredirect", strlen(argv[1])) == 0) {
	Tcl_AppendResult(interp, "Wm overrideredirect is not permitted in Safe-Tcl.", (char *) NULL); 
	return TCL_ERROR;
    }
    if (strncmp(argv[1], "geometry", strlen(argv[1])) == 0) {
	static int NumGeoms = -42;
	if (NumGeoms == -42) {
	    char *s = Tcl_GetVar(unrestricted_interp, "swish_GeometryLimit", TCL_GLOBAL_ONLY);
	    NumGeoms = s ? atoi(s) : 60;
	}
	if (NumGeoms < 0) {
	    Tcl_AppendResult(interp, "Only a limited number of \"wm geometry\" calls are permitted in Safe-Tcl (configurable via swish_GeometryLimit).", (char *) NULL);
	    return TCL_ERROR;
	}
	--NumGeoms;
	if (argc > 3  && index(argv[3], '-') != NULL) {
	    Tcl_AppendResult(interp, "Negative geometry offsets are not permitted in Safe-Tcl.", (char *) NULL); 
	    return TCL_ERROR;
       }
    }
    return Tk_WmCmd(clientData, interp, argc, argv);
}

int
SafeTcl_GrabCmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
    int i, j;

    for (i=1; i<argc; ++i) {
     if (strncmp(argv[i], "-global", strlen(argv[i])) == 0) {
          for (j=i; j<argc; ++j) {
          argv[j] = argv[j+1];
      }
     --argc;
       --i;
      }
    }
    return Tk_GrabCmd(clientData, interp, argc, argv);
}

int
SafeTcl_FrameCmd(clientData, interp, argc, argv)
ClientData clientData;	/* Main window associated with
				 * interpreter. */
Tcl_Interp *interp;		/* Current interpreter. */
int argc;			/* Number of arguments. */
char **argv;		/* Argument strings. */
{
    argv[0] = "frame"; /* No hole for toplevel */
    return Tk_FrameCmd(clientData, interp, argc, argv);
}

SafeTcl_PlaceCmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
    char *wintocheck=argv[1];
    /* First check for window-names that subvert decorations */
    if (!strncmp(argv[1], "configure", strlen(argv[1]))) wintocheck=argv[2];
    if (wintocheck[0] == '.') {
	/* Must have THREE periods */
	wintocheck=index(++wintocheck, '.');
	if (wintocheck) wintocheck=index(++wintocheck, '.');
	if (!wintocheck) {
	    Tcl_AppendResult(interp, "This program is attempting to use place to subvert Safe-Tcl window decorations!", (char *) NULL);
	    return TCL_ERROR;
	}
    }
    if (!In_Mkwindow && (IsCriticalWindow(argv[1]) || (argc > 2 && IsCriticalWindow(argv[2])))) {
        Tcl_AppendResult(interp, "This program is attempting to use place to subvert Safe-Tcl window decorations!", (char *) NULL);
        return TCL_ERROR;
    }
    return Tk_PlaceCmd(clientData, interp, argc, argv);
}

SafeTcl_ListFontsCmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
    char *pattern = "*", **fonts;
    int nnames =1000, available = nnames+1, ctr;
    Tk_Window tkwin = (Tk_Window) clientData;
    Display *dpy = Tk_Display(tkwin);

    if (argc > 2) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			 " [pattern]\"", (char *) NULL);
	return TCL_ERROR;
    }
    if (argc == 2) pattern = argv[1];
    for (;;) {
	fonts = XListFonts(dpy, pattern, nnames, &available);
	if (fonts == NULL || available < nnames) break;
	XFreeFontNames(fonts); 
	nnames = available * 2;
    }
    Tcl_ResetResult(interp);
    for (ctr=0; ctr<available; ++ctr) {
	Tcl_AppendElement(interp, fonts[ctr]);
    }
    XFreeFontNames(fonts);
    return TCL_OK;
}

void
RegisterInterfaceStyleCommands( restricted_interp, w )
    Tcl_Interp *restricted_interp;
    Tk_Window w;
{
    Tcl_CreateCommand(restricted_interp, "mkwindow", MkWindow_Cmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "destroy", SafeTcl_DestroyCmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "wm", SafeTcl_WmCmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "grab", SafeTcl_GrabCmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "pack", SafeTcl_PackCmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "place", SafeTcl_PlaceCmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "frame", SafeTcl_FrameCmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "SafeTcl_ListFonts", SafeTcl_ListFontsCmd,
                       (ClientData) w, (void (*) ()) 0);
}
