#ifndef NO_RLIMITS
#include <sys/time.h>
#include <sys/resource.h>
#endif
#include <tk.h>

extern char *getenv(), *index();
extern int  swish_ftruncate();

Tcl_Interp *unrestricted_interp; /* Unrestricted interpreter */
Tcl_Interp *restricted_interp; /* Restricted interpreter */
int TkRunning=0;                /* Global indicating Tk initialized successfully */
int runsafely = 0;
int messaging = 0;
int generic = 0;
char *progname = "swish";
char *Mailbox = NULL;
char *MsgBodyFile = NULL;
extern char *SafeTcl_message;
extern char *InitContents, *TkContents, *ButtonContents, *MenuContents;
char *InitEval = NULL;
Tk_ArgvInfo swishargTable[] = {
    {"-safe", TK_ARGV_CONSTANT, (char *) 1, (char *) &runsafely,
	"Run untrusted program in safe-tcl mode"},
    {"-messaging", TK_ARGV_CONSTANT, (char *) 1, (char *) &messaging,
	"Add messaging-related primitives"},
    {"-generic", TK_ARGV_CONSTANT, (char *) 1, (char *) &generic,
	"Run program in generic interface mode (no Tk/X11)"},
    {"-mailbox", TK_ARGV_STRING, (char *) NULL, (char *) &Mailbox,
	"Default Mailbox"},
    {"-messagebody", TK_ARGV_STRING, (char *) NULL, (char *) &MsgBodyFile,
	"File containing message body for MIME enabled-mail message"},
    {"-messagefile", TK_ARGV_STRING, (char *) NULL, (char *) &MsgBodyFile,
	"File containing message body for MIME enabled-mail message (synonym for -messagebody)"},
    {"-initeval", TK_ARGV_STRING, (char *) NULL, (char *) &InitEval, "Specify additional Tcl initialization code"},
    {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,
	(char *) NULL}
};

/*
 * The following variable is a special hack that allows applications
 * to be linked using the procedure "main" from the Tk library.  The
 * variable generates a reference to "main", which causes main to
 * be brought in from the library (and all of Tk and Tcl with it).
 */

extern int main();
int *tclDummyMainPtr = (int *) main;

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{
    Tk_Window w = NULL;
    int argc, result;
    char buf[20], *args, **argv;

    if (InitTclLibs(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#ifdef USE_TCLX
    TclXCmd_Init (interp);
#endif
    Tcl_CreateCommand (interp, "ftruncate", swish_ftruncate,
                       (ClientData) 0, (void (*) ()) 0);
#ifdef USE_TCLDP
    Tdp_Init (interp);
#endif
    argc = atoi(Tcl_GetVar(interp, "argc", TCL_GLOBAL_ONLY));
    Tcl_SplitList(interp, Tcl_GetVar(interp, "argv", TCL_GLOBAL_ONLY), &argc, &argv);
    if (Tk_ParseArgv(interp, (Tk_Window) NULL, &argc, argv, swishargTable, TK_ARGV_DONT_SKIP_FIRST_ARG)
	!= TCL_OK) {
	fprintf(stderr, "%s\n", interp->result);
	exit(1);
    }
    args = Tcl_Merge(argc, argv);
    Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    sprintf(buf, "%d", argc);
    Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);
    if (Tcl_NoInterface ())	/* simplifies the code that follows */
	generic = 1;
    if (! Tk_RunningX()) {
	generic = 1;
    } else if (generic) {
	if (Tcl_Eval(interp, "wm withdraw .") != TCL_OK) {
	    return(TCL_ERROR);
	}
    }
    if (!generic && InitTkLibs(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (runsafely) {
	char *libDir;
	Tk_Window w;
	restricted_interp = interp;
	unrestricted_interp = (Tcl_Interp *) Tcl_CreateInterp();
#ifdef TCL_MEM_DEBUG
        Tcl_InitMemory(unrestricted_interp);
#endif
        Tcl_SetVar(restricted_interp, "SafeTcl_evaluation_time",
		   Tcl_NoInterface () ? "delivery" : "activation",
		   TCL_GLOBAL_ONLY);
	if (!generic) {
	    extern char *display;
	    w = Tk_CreateMainWindow(unrestricted_interp, display, "swish", "Tk");
	    if (w == NULL) {
	/* Still need to define the library, etc. */
		libDir = getenv("TK_LIBRARY");
		if (libDir == NULL) {
		    libDir = TK_LIBRARY;
		}
		Tcl_SetVar(unrestricted_interp, "tk_library", libDir, TCL_GLOBAL_ONLY);
		Tcl_SetVar(unrestricted_interp, "tk_version", TK_VERSION, TCL_GLOBAL_ONLY);
		Tcl_SetVar(unrestricted_interp, "tkVersion", TK_VERSION, TCL_GLOBAL_ONLY);
	    }
	}
	if (!generic && InitTkLibs(unrestricted_interp) == TCL_ERROR) {
	    char *m;
	/* Propogate the error to the restricted interpreter for reporting */
	    Tcl_SetResult(restricted_interp, unrestricted_interp->result, TCL_VOLATILE);
	    m = Tcl_GetVar(unrestricted_interp, "errorInfo", TCL_GLOBAL_ONLY);
	    Tcl_AddErrorInfo(restricted_interp, m ? m : "<no error info>");
	    m = Tcl_GetVar(unrestricted_interp, "errorCode", TCL_GLOBAL_ONLY);
	    if (m) Tcl_SetErrorCode(restricted_interp, m, 0);
Tcl_Eval(unrestricted_interp, "puts stdout [info procs]");
	    return TCL_ERROR;
	}
    } else {
	unrestricted_interp = interp; /* This variable should always be set */
	restricted_interp = NULL;
	if (Tcl_NoInterface () && messaging) {
	    InitReceipt (unrestricted_interp);
	    Tcl_SetVar (unrestricted_interp, "SafeTcl_evaluation_time", "receipt",
			TCL_GLOBAL_ONLY);
	}
    }
    /* Note that "interp" is the one with Tk initialization done in it.  This is the restricted interpreter IF one exists. */
    if (!generic) w = Tk_MainWindow(interp);
    if (w == NULL) {
        /* Still need to define the library, etc. */
        char *libDir = getenv("TK_LIBRARY");
        if (libDir == NULL) {
            libDir = TK_LIBRARY;
        }
        Tcl_SetVar(interp, "tk_library", libDir, TCL_GLOBAL_ONLY);
        Tcl_SetVar(interp, "tk_version", TK_VERSION, TCL_GLOBAL_ONLY);
        Tcl_SetVar(interp, "tkVersion", TK_VERSION, TCL_GLOBAL_ONLY);
    } else {
	TkRunning=!generic;
    }
    if (Tcl_VarEval(interp, InitContents, "\n", generic ? "" : MenuContents, "\n", generic ? "" : TkContents, "\n", generic ? "" : ButtonContents, "\n", 0, (char **) NULL) != TCL_OK) return TCL_ERROR;
    if (InitEval && Tcl_GlobalEval(unrestricted_interp, InitEval) != TCL_OK) return TCL_ERROR;
    if (runsafely && Tcl_MakeInterpreterSafe(restricted_interp, unrestricted_interp, w, generic) != TCL_OK) return TCL_ERROR;
    progname = (char *) Tk_ProgramName();
    if (!progname) progname = "swish";
    if (InitMessageBody(interp, progname, MsgBodyFile)) return TCL_ERROR;
    if (messaging) {
	if (restricted_interp)
	    InitMessaging (restricted_interp, progname, Mailbox, 0);
        InitMessaging (unrestricted_interp, progname, Mailbox, 1);
    }
    if (Tcl_NoInterface ()) {
        RemoveInterface(interp, interp);
    }
    if (runsafely && Tcl_Eval(unrestricted_interp, "init_safe_tcl") != TCL_OK) {
        /* Final initialization, once everything is defined */
        char *m;
        /* Propogate the error to the restricted interpreter for reporting */
        Tcl_SetResult(restricted_interp, unrestricted_interp->result, TCL_VOLATILE);
        m = Tcl_GetVar(unrestricted_interp, "errorInfo", TCL_GLOBAL_ONLY);
        Tcl_AddErrorInfo(restricted_interp, m ? m : "<no error info>");
        m = Tcl_GetVar(unrestricted_interp, "errorCode", TCL_GLOBAL_ONLY);
        if (m) Tcl_SetErrorCode(restricted_interp, m, 0);
        return TCL_ERROR;
    }
    InitLimits(unrestricted_interp);
    if (Tcl_NoInterface ())
	Tcl_DoEvalAndExit ();

    return TCL_OK;
}

extern char *ButtonContents, *TkContents, *EntryContents, *ListboxContents, *MenuContents, *TextContents, *TkerrorContents, *InitContents;

InitTclLibs(interp)
Tcl_Interp *interp;
{
    if (Tcl_VarEval(interp, InitContents, 0, (char **) NULL) != TCL_OK) {
	return(TCL_ERROR);
    }
    return(TCL_OK);
}

InitTkLibs(interp)
Tcl_Interp *interp;
{
    if (Tcl_VarEval(interp, ButtonContents, "\n", EntryContents, "\n", ListboxContents, "\n", MenuContents, "\n", TextContents, "\n", TkContents, "\n", TkerrorContents, "\n", InitContents, "\n", 0, (char **) NULL) != TCL_OK) {
	return TCL_ERROR;
    }
    return(TCL_OK);
}

InitLimits(interp)
Tcl_Interp *interp; /* Unrestricted interpreter */
{
#ifndef NO_RLIMITS
    struct rlimit rlp;
    char *s;

    getrlimit(RLIMIT_CPU, &rlp);
    rlp.rlim_cur = 0;
    s = Tcl_GetVar(interp, "swish_CPULimit", TCL_GLOBAL_ONLY);
    if (s) rlp.rlim_cur = atoi(s);
    if (rlp.rlim_cur <= 0) rlp.rlim_cur = 90;
    setrlimit(RLIMIT_CPU, &rlp);
#endif
}
