# This is the file that gets loaded into the restricted Safe-Tcl interpreter 
# BEFORE it is restricted.
#
# This file is unlikely to need many extensions.  The best way to extend the 
# Safe-Tcl  interpreter is to put your extensions in ~/.safetclrc.  
# Extensions to the system itself can be made by defining procs in 
# unrestrict.tcl and exporting them to the restricted interpreter 
# using declareharmless.

set swish_version "1.2"

if {[lsearch $SafeTcl_InterfaceStyle Tk3.*] >= 0} {
    wm withdraw .
}
set WinCtr 0

proc tkerror err {
    global errorInfo
    set info $errorInfo

    set w [mkwindow]
    label $w.lab -text "Error in Tcl Script: Error: $err"
    button $w.ok -text OK -command "destroy $w"
    text $w.text -relief raised -bd 2 -yscrollcommand "$w.scroll set" \
	    -setgrid true -width 40 -height 10
    scrollbar $w.scroll -relief flat -command "$w.text yview"
    pack $w.lab -side top 
    pack $w.ok -side bottom -padx 3m -pady 3m -ipadx 2m -ipady 1m
    pack $w.scroll -side right -fill y
    pack $w.text -side left -expand yes -fill both
    $w.text insert 0.0 "	>>> Stack Trace <<<\n\n"
    $w.text insert end $info
    $w.text mark set insert 0.0
}
