#
# MTR's receipt-time script, invoked under .forward as:
#
#     "| LD_LIBRARY_PATH=/usr/openwin/lib /usr/local/bin/swish -nointerface -messaging -messagebody - -file .receipt.tcl"
#
#
# daily clean-up:
#
#    find $HOME/mhbox/.badaddrs \! -atime   -7 -exec rm {} \;
#    find $HOME/mhbox/.msgids   \! -atime   -7 -exec rm {} \;
#    find $HOME/mhbox/.tmpaddrs \! -atime  -28 -exec rm {} \;
#


#
# simple logging package
#
set	logident	[format "%-8s" "receipt"]
set	logfile		".receipt.log"

set	logfd	""
set	logpid	""
set	loguser	""
set logmonth(Jan) 1
set logmonth(Feb) 2
set logmonth(Mar) 3
set logmonth(Apr) 4
set logmonth(May) 5
set logmonth(Jun) 6
set logmonth(Jul) 7
set logmonth(Aug) 8
set logmonth(Sep) 9
set logmonth(Oct) 10
set logmonth(Nov) 11
set logmonth(Dec) 12

proc	logwrite {string} {
    global    env logfd logfile logident logmonth logpid loguser

    set now [SafeTcl_getdateprop "" proper]

    if {$logfd == ""} {
	if {[catch { set logfd [open $logfile "a"] }]} {
	    return
	}

	set	logpid	[format "%05d" [pid]]
	if {[catch { set loguser [format "%-8s" $env(USER)] }]} {
	    set	loguser	[format "%-8s" [concat "#" [id userid]]]
	}
    } else {
	seek	$logfd	0 end
    }

    set date [format "%s/%s %s" $logmonth([string range $now 8 10]) \
                     [string range $now 5 6] [string range $now 17 24]]
    puts $logfd "$date $logident $logpid $loguser $string"
}

proc	logclose {} {
    global    logfd

    if {$logfd != ""} {
	catch { close $logfd }
	set	logfd	""
    }
}


#
# pick up any user definitions
#
catch { source ".safetcl.conf" }


#
# keep an audit copy
#
MIME_savemessage	mbox	"mhbox/INCOMING"


#
# find out who originated the message
#
if {([set from [set orig [SafeTcl_getheader "From"]]] == "")
	&& ([set from [SafeTcl_getheader "Sender"]] == "")
	&& ([set from [SafeTcl_getheader "Return-Path"]] == "")} {
    catch { set from $SafeTcl_Originator }
}
set	mbox	""
catch { set mbox [string tolower [SafeTcl_getaddrprop $from "local"]] }

if {$mbox == "m.rose"} {
    MIME_savemessage mbox	"mhbox/OUTGOING"
}


regsub  -all	"  *" [set subject [SafeTcl_getheader "Subject"]] " " subject


#
# see if this is a duplicate
#
if {(([set id [SafeTcl_getheader "Resent-Message-ID"]] != "")
	    || ([set id [SafeTcl_getheader "Message-ID"]] != ""))} {
    set	mid	[join [split $id "/"] "_"]
    if {[file exists mhbox/.msgids/$mid]} {
	logwrite	"duplicate ID: $from $id ($subject)"
	return
    } elseif {[catch { set file [open mhbox/.msgids/$mid "w"] } result]} {
	logwrite	$result
    } else {
	close	$file
    }
}


#
# add to list of incoming correspondents
#
if {![catch { set origaddr [SafeTcl_getaddrprop $orig "address"] }]} {
    set	    origfile	[string tolower [join [split $origaddr "/"] "_"]]
    if {(![file exists [set infile mhbox/.inaddrs/$origfile]]) \
	    && (![catch { set file [open $infile "w"] }])} {
	set	proper	$origaddr
	catch { set proper [SafeTcl_getaddrprop $orig proper] }

	puts	$file	$proper
	close	$file
    }
} else {
    set	    origaddr	""
    set	    origfile	""
}

if {([set resent [SafeTcl_getheader "Resent-From"]] != "") \
	&& ![catch { set resentaddr [SafeTcl_getaddrprop $resent \
				         "address"] }]} {
    set	    origfile	[string tolower [join [split $resentaddr "/"] "_"]]
}

#
# decide if it's worth dealing with
#

proc	processP	{mbox} {
    switch -- $mbox {
	antigone-fax-manager
	    -
	faxmaster
	    -
	numbers-info-forw
	    -
	radiohelp
	    -

	archive-server
	    -
	failrepter
	    -
	mail
	    -
	mailer
	    -
	mailer-agent
	    -
	mailer-daemon
	    -
	x-400-mailer-daemon
	    -
	-maiser-
	    -
	mmdf
	    -
	mx-mailer-daemon
	    -
	postman
	    -
	pp
	    -
	smtp
	    -
	uucp {
	    return  1
	}

	default {
	    return [string match postmast* $mbox]
	}
    }

    return	0
}

proc	clientP	{host}	{
    foreach	domain	[list dbc.mtview.ca.us \
			      interop.com  *.interop.com \
			      zdexpos.com  *.zdexpos.com \
			      ziff.com	   *.ziff.com \
			      psi.com      *.psi.com \
			      psi.net      *.psi.net \
			      internic.net *.internic.net] {
	if {[string match $domain $host]} {
	    return	1
	}
    }

    return	0
}

set	host	""
catch { set host [string tolower [SafeTcl_getaddrprop $orig "domain"]] }

if {(![processP $mbox]) \
	&& (![clientP $host]) \
	&& (![string match "private:*" [string tolower $subject]])} {
    if {(![file exists mhbox/.outaddrs/$origfile]) \
	    && (![file exists mhbox/.tmpaddrs/$origfile])} {
	set	text	\
"This is an automated reply from Marshall Rose's enabled mailbox.

I process several hundred messages each day, so it is important that
only personal mail be sent to Marshall Rose's personal mailbox.  You
have sent a message to his personal mailbox, but you do not appear to
be someone that he corresponds with regularly.

Your message has been archived, but probably won't be read by him.

Please check this list and see if there is a more appropriate address:

    Topic                               Address to use
    -----                               --------------
    First Virtual Holdings              mrose.fv@fv.com
    IAB/IETF Nominating Committee       mrose.nomcom@dbc.mtview.ca.us
    Internet Engineering Task Force     mrose.iesg@dbc.mtview.ca.us
    Networld+Interop Program Committee  mrose.interop@dbc.mtview.ca.us
    ISODE                               isode@nic.ddn.mil
      4BSD/ISODE SNMP                   isode-snmpV2@cs.utk.edu
    MH                                  mh-users@ics.uci.edu
      ..                                mh-workers@ics.uci.edu
    North American Directory Forum      mrose.nadf@dbc.mtview.ca.us
    Post Office Protocol (POP3)         ietf-pop3@andrew.cmu.edu
    Safe-Tcl                            safe-tcl@cs.utk.edu
    SNMP                                snmp@psi.com
      SNMP+Tcl				snmptcl-users@cisco.com
        ..                              snmptcl-workers@cisco.com
      SNMP Testing                      snmp-test@netcom.com
    The Simple Times                    st-editorial@dbc.mtview.ca.us
    TPC.INT                             tpc-admin@town.hall.org

If so, please resend your message accordingly.

If not, please resend your message to his personal mailbox, and start
the Subject: field with 'private:'

/mtr

ps: Please accept my apology if you received this message in error.
"

	set	rsubject	[string trim $subject]
	while {([string match Re:* $rsubject]) \
		    || ([string match re:* $rsubject])} {
	    set	rsubject	[string trimleft \
				     [string range $rsubject 3 end]]
	}
	if {[file exists mhbox/.badaddrs/$origfile]} {
	    exec 	/bin/rm -f mhbox/.badaddrs/$origfile
	    return
	} elseif {[catch { MIME_sendmessage -to $orig -subject \
			       "Re: $rsubject" \
		               -body [SafeTcl_makebody "text/plain" \
				          -parameter "charset=us-ascii" \
					  $text] } \
	         result]} {
	    logwrite	"unable to send notice: $result"
	} else {
	    catch { close [open mhbox/.badaddrs/$origfile "w"] }
	    return
	}
    }
}

#
# add to list of auxiliary correspondents
#
if {![processP $mbox]} {
    foreach header	[list "To" "cc"] {
	if {[set value [SafeTcl_getheader $header]] != ""} {
	    if {[catch { set addrs [SafeTcl_getaddrs $value] } result]} {
		continue
	    }
	    foreach hdraddr	$addrs {
		if {(![catch { set host [SafeTcl_getaddrprop $hdraddr \
					    "domain"] }]) \
			&& [clientP $host]} {
		    continue
		}			
		if {[catch { set addr [SafeTcl_getaddrprop $hdraddr \
				           "address"] }]} {
		    continue
		}
		set	addrfile	[string tolower \
					     [join [split $addr "/"] "_"]]
		if {(![file exists mhbox/.outaddrs/$addrfile]) \
			&& (![file exists \
			          [set tmpfile mhbox/.tmpaddrs/$addrfile]]) \
			&& (![catch { set file [open $tmpfile "w"] }])} {
		    set	proper		$addr
		    catch { set proper [SafeTcl_getaddrprop $hdraddr \
					    "proper"] }

		    puts	$file	$proper
		    close	$file
		}
	    }
	}
    }
}


#
# save a copy in the default mailbox
#
MIME_savemessage	mbox


#
# sends RadioMail, if appropriate
#
proc	radiomail	{} {
    global	PERSMBOX IGNMBOX IGNSUBJ RADIOMAIL SIZE PAGER SPLIT
    global	SafeTcl_Originator from mbox subject
    global	text textlen

    if {($from == "") || ($mbox == "")} {
	return
    }


#
# .radiomail-init.tcl defines several variables:
#	PERSMBOX  - list of personal lhs-addresses
#	IGNMBOX	  - list of originator lhs-addresses to ignore
#	IGNSUBJ	  - list of subjects to ignore
#	RADIOMAIL - address to send to
#	SIZE	  - maximum size of body to send
#	PAGER	  - model of device, e.g., advisor, 95lx, or powerbook
#	SPLIT	  - maximum size of each chunk (for, e.g., advisors)
#
# two examples are at the end of this file
#
    if {[catch { source ".radiomail-init.tcl" }]} {
	return
    }


#
# see if the message is personally addressed
#
    if {(![mboxP "To" $PERSMBOX]) && (![mboxP "cc" $PERSMBOX])} {
	return
    }


#
# see if it's from a mail-related process
#
    if {[processP $mbox]} {
	return
    }


#
# see if the originator is someone we don't care to hear from
#
    foreach	ignore	$IGNMBOX {
	if {[regexp $ignore $mbox]}		{ return }
    }


#
# see if the subject is something we don't care to hear about
#
    foreach	ignore	$IGNSUBJ {
	if {[regexp -nocase $ignore $subject]}	{ return }
    }


#
# if to a pager, start with a prefix
#
    if {$PAGER == "advisor"} {
	set	person	""
	catch { set person [string trimleft \
			        [string trimright \
				     [SafeTcl_getaddrprop $from "friendly"] \
				          "\""] "\""] }
	if {($person != "")
		&& ![catch { set file [open ".phone.txt" "r"] }]} {
	    while {[gets $file line] >= 0} {
		set	fields	[split $line "\t"]
		set	glen	[string length [set given [lindex $fields 0]]]
		set	full	"$given [set sur [lindex $fields 1]]"
		if {($glen > 3) \
		        && ([string range $given [expr $glen-1] end] == ".")} {
		    set	given	[string range $given 0 [expr $glen-4]]
		}
		if {($full == $person) \
			|| ("$given $sur" == $person) \
			|| ([lindex $fields 2] == $person)} {
		    foreach	phone	[lrange $fields 5 end] {
			if {[set phone [string trim $phone]] != ""} {
			    break
			}
		    }
		    if {[string range $phone 0 2] == "+1 "} {
			set	phone	[string range $phone 3 end]
		    }
		    set		person	"$person $phone"
		    break
		}
	    }
	    close	$file
	}

	set	    text	"$person "
	if {![catch { set rclock [SafeTcl_getdateprop \
				      [SafeTcl_getheader "Date"] \
				      "rclock"] }]} {
	          if {($rclock > 604800)} {
			append text [expr $rclock/604800] "w "
	    } elseif {($rclock >  86400)} {
			append text [expr $rclock/86400]  "d "
	    } elseif {($rclock >   3600)} {
			append text [expr $rclock/3600]   "h "
	    } elseif {($rclock >     60)} {
			append text [expr $rclock/60]     "m "
	    }
	}
	if {$subject != ""}			{ append  text "$subject " }
    } else {
	set	text	""
    }
    set	    textlen	[string length $text]


#
# collect the text
#
    set	    vector	[list [list "text/plain"	addtext] \
			      [list "text/richtext" addrichtext]]
    if {$PAGER == "powerbook"} {
	lappend	vector	      [list "application/pgp" addrawtext]
    }

    process $vector "1" [SafeTcl_getparts] ""
    if {$textlen < $SIZE} {
	append	text	"##\n"
	incr	textlen	3
    }


#
# not to a pager...
#
    if {$PAGER != "advisor"} {
	if {[catch { SafeTcl_getaddrs [set to [SafeTcl_getheader "To"]] }]} {
	    set	    to	$RADIOMAIL
	}
	if {[catch { SafeTcl_getaddrs [set cc [SafeTcl_getheader "cc"]] }]} {
	    set	    cc	""
	}
	if {[catch { set date [SafeTcl_getdateprop [SafeTcl_getheader "date"] \
			           "proper"] }]} {
	    set	    date	[SafeTcl_getdateprop "" "proper"]
	}

	logwrite	"$from $subject -> $RADIOMAIL"
	if {[catch { MIME_sendmessage -to $to -cc $cc -subject $subject \
			 -auxheader "Date"      $date \
			 -auxheader "From"      $from \
			 -auxheader "Resent-To" $RADIOMAIL \
			 -resent \
			 -body [SafeTcl_makebody "text/plain" \
				    -parameter "charset=us-ascii" \
				    $text] } result]} {
	    logwrite	"unable to send radiomail: $result"
	}

	return
    }


#
# small enough to send it one-shot
#
    if {$textlen <= $SPLIT} {
	logwrite	"$from $subject -> $RADIOMAIL"
	if {[catch { MIME_sendmessage -to $RADIOMAIL -subject $subject \
			 -body [SafeTcl_makebody "text/plain" \
				    -parameter "charset=us-ascii" \
				    $text] } result]} {
	    logwrite	"unable to send radiomail: $result"
	}

	return
    }


#
# otherwise, fragment it...
#
    for {set offset 0} {$textlen > 0} {incr offset} {
	set	body	[concat $offset \
			     [string range $text 0 [expr $SPLIT-1]]]
	logwrite	"$from $subject -> $RADIOMAIL $offset"
	if {[catch { MIME_sendmessage -to $RADIOMAIL -subject $subject \
		         -body [SafeTcl_makebody "text/plain" \
				    -parameter "charset=us-ascii" $body] } \
	         result]} {
	    logwrite	"unable to send radiomail: $result"
	    break
	}

	set	text	[string range $text $SPLIT end]
	incr	textlen	-$SPLIT
    }
}


#
# checks if a header field contains particular local mailbox
#
proc    mboxP   {header mboxes} {
    foreach     addr    [SafeTcl_getaddrs [SafeTcl_getheader $header]] {
	if {[catch { set local [SafeTcl_getaddrprop $addr "local"] } ]} {
	    continue
	}
	foreach	mbox    $mboxes {
	    if {[regexp -nocase $mbox $local]} {
		return 1
	    }
	}
    }

    return      0
}


#
# recursively process a message
#
proc	process		{vector partno parts body} {
#
# find the record corresponding to the part
#
    foreach	part	$parts {
	if {[lindex $part 0] == $partno} {
	    break
	}
    }

#
# process that content type
#
    case [set type [lindex $part 1]] {
	"message/rfc822"	{
		set	message	[SafeTcl_getbodyprop $partno "value" $body]
		return	[process $vector "1" [SafeTcl_getparts $message] \
			     $message]
	}

	"multipart/alternative" {
	    set		invert	""
	    set		partsub	"^$partno"
	    append	partsub	"." \[ 1-9 \] "*$"
	    foreach	part	$parts {
		set	newpart	[lindex $part 0]
		if {[regexp $partsub $newpart]} {
		    set		invert	[linsert $invert 0 $part]
		}
	    }
	    foreach	newpart	$invert {
		if {[set result [process $vector $newpart $parts $body]]} {
		    return $result
		}
	    }
	}

	"multipart/*"		{
	    set		partsub	"^$partno"
	    append	partsub	"." \[ 1-9 \] "*$"
	    set		result	0
	    foreach	part	$parts {
		set	newpart	[lindex $part 0]
		if {[regexp $partsub $newpart]} {
		    case [process $vector $newpart $parts $body] {
			-1	{ return -1 }

			0	{ }

			default	{ incr result }
		    }
		}
	    }
	    return	$result
	}

	default			{
	    foreach vec $vector {
		if {[lindex $vec 0] == $type} {
		    return [eval [lindex $vec 1] "$partno" {$body}]
		}
	    }
	    return 0
	}
    }
}


#
# collect textual content
#
proc	addtext		{partno body} {
    global	SIZE PAGER
    global	text textlen

    if {[catch { set raw [SafeTcl_decode \
			      [SafeTcl_getbodyprop $partno "encoding" $body] \
			      [SafeTcl_getbodyprop $partno "value" $body]]}]} {
	return 0
    }

    set	    bogon1	[list "^Marshall: *$" \
			      "^MHS:   Source date is:.*$" \
			      "^.* writes:$" \
			      "^.* you write:$" \
			      "^On .* you said:$" \
			      "\\*\\*\\* Reply to note of" \
			      "^To:>" \
			      "^\[ \t\]*From: " \
			      "^\[ \t\]*Reply to:\[ \t\]*RE>"]
    set	    bogon2	[list "^%!" "^begin \[0-7\]\[0-7\]\[0-7\] " "^% -\\*- " "^xbtoa Begin"]
    set	    cooked	""
    set	    indented	0
    set	    slurping	0
    set	    started	0

    set	    lines	[split [string trim $raw] "\n"]
    foreach line	$lines {
	if {[regexp {^Excerpts from mail: }	$line]} {
	    if {!$started}		{ set slurping 1; continue }
	} elseif {[regexp {^[ \t][ \t]*To: } $line]} {
	    if {$started}		{ break }
	    continue
	} elseif {[regexp {^[ \t][ \t]*Date: }	$line]} {
	    if {$started}		{ set indented 1; continue }
	} elseif {[regexp {^ *-----}		$line]} {
	    if {$PAGER == "advisor"}		{ break }
	} elseif {[regexp {^_____}		$line]} {
	    if {$PAGER == "advisor"}		{ break }
	} elseif {[regexp {^[ \t]*>}		$line]} {
	    if {$PAGER == "advisor"}		{ continue }
	} elseif {[regexp {^[ \t][ \t]*[^ \t]}	$line]} {
	    if {$indented}		{ continue }
	} else {
	    if {!$started} {
		set	ignore	0
		foreach	bogon	$bogon1 {
		    if {[regexp $bogon $line]} {
			set	ignore	1
			break
		    }
		}
		if {$ignore}		{ continue }
	    }

	    set	    exiting	0
	    foreach bogon	$bogon2 {
		if {[regexp $bogon $line]} {
		    set	    exiting	1
		    break
		}
	    }
	    if {$exiting}		{ break }
	}
	if {$slurping} {
	    if {$line == ""}		{ set slurping 0 }
	    continue
	}
	if {((!$started) || ($PAGER == "advisor")) && ($line == "")} {
	    continue
	}
	set	started		1
	set	indented	0
	if {$PAGER == "advisor"} {
	    set		line	[string trim $line]
	    regsub	-all	"  *" $line " " line
	}
	append	cooked		$line "\n"
    }

    if {$textlen > 0} {
	append	text	"#\n"
	incr	textlen	2
    }
    append	text	$cooked
    if {[incr textlen [string length $cooked]] > $SIZE} {
	set	text	[string range $text 0 [expr [set textlen $SIZE]-1]]
	return	-1
    }
    return	1
}


#
# collect richtext context
#
proc	addrichtext	{partno body} {
    global	SIZE
    global	text textlen

    if {[catch { set raw [SafeTcl_decode \
			      [SafeTcl_getbodyprop $partno "encoding" $body] \
			      [SafeTcl_getbodyprop $partno "value" $body]]}]} {
	return 0
    }

    set	    cooked	[string trim [exec /usr/local/lib/mh/rt2raw << $raw]]

    if {$textlen > 0} {
	append	text	"#\n"
	incr	textlen	2
    }
    append	text	$cooked "\n"
    if {[incr textlen [string length $cooked]] > $SIZE} {
	set	text	[string range $text 0 [expr [set textlen $SIZE]-1]]
	return	-1
    }
    return	1
}


#
# collect pgp context
#
proc	addrawtext	{partno body} {
    global	SIZE
    global	text textlen

    if {[catch { set raw [SafeTcl_decode \
			      [SafeTcl_getbodyprop $partno "encoding" $body] \
			      [SafeTcl_getbodyprop $partno "value" $body]]}]} {
	return 0
    }

    if {$textlen > 0} {
	append	text	"#\n"
	incr	textlen	2
    }
    append	text	$raw "\n"
    if {[incr textlen [string length $raw]] > $SIZE} {
	set	text	[string range $text 0 [expr [set textlen $SIZE]-1]]
	return	-1
    }
    return	1
}


#
# send radiomail, if appropriate
#
if {[catch { radiomail } result]} {
    logwrite	"radiomail: $result"
}


#
# decide if we should cache this content
#
catch {
    if {([set cid [SafeTcl_getheader "Content-ID"]] != "")
	    && ([SafeTcl_getbodyprop "1" "type"] != "message/partial")
	    && [string match "*-server-request" $mbox]} {
	if {[catch { MIME_savemessage cache } result]} {
	    logwrite	"unable to cache ID $id (content $cid): $result"
	} else {
	    logwrite	"cached ID $id (content $cid)"
	}
    }
}


#
# and, finally, let's load the cache with whatever stuff we can
#
proc	addcache	{partno body} {
    global	id

    append	partno	".1"

    if {[catch { SafeTcl_getbodyprop $partno "size" $body } result]} {
	logwrite	"unable to get $partno's size for $id: $result"
    }
}

if {[regexp -nocase "^re:" $subject]} {
    catch {
	set	me	"^[SafeTcl_getaddrprop $SafeTcl_Recipient local]$"

	if {([mboxP "To" $me])
		|| ([mboxP "cc" $me])
		|| ([mboxP "Resent-To" $me])
		|| ([mboxP "Resent-cc" $me])} {
	    process [list [list "message/external-body" addcache]] "1" \
	        [SafeTcl_getparts] ""
	}
    }
}

return




#
# example .radiomail-init.tcl (for an alphanumeric pager)
#

set	PERSMBOX	[list "^mrose$" "^postmaster$"]
set	IGNMBOX		[list "m.rose"]
set	IGNSUBJ		[list "MIB for checking"]

set	RADIOMAIL	"user@radiomail.net"
set	SIZE		525
set	PAGER		"advisor"
set	SPLIT		120


#
# example .radiomail-init.tcl (for a palmtop)
#

set	PERSMBOX	[list "^mrose$" "^postmaster$"]
set	IGNMBOX		[list "m.rose"]
set	IGNSUBJ		[list "MIB for checking"]

set	RADIOMAIL	"user@radiomail.net"
set	SIZE		10000
set	PAGER		"95lx"
set	SPLIT		0


#
# example .radiomail-init.tcl (for a laptop)
#

set	PERSMBOX	[list "^mrose$" "^postmaster$"]
set	IGNMBOX		[list "m.rose"]
set	IGNSUBJ		[list "MIB for checking"]

set	RADIOMAIL	"user@radiomail.net"
set	SIZE		65000
set	PAGER		"powerbook"
set	SPLIT		0
