#!compilewish

[compile {
#
# Window manager configuration
#
wm title . pong
wm positionfrom . program
wm sizefrom . user
wm maxsize . 1152 900

#
# Command frame
#
frame .cmdframe 
pack .cmdframe  -expand no -fill x -anchor n

#
# Quit Button
#
button .cmdframe.quit -text "Quit" -command exit
pack .cmdframe.quit -side left

#
# New Game Button
#
button .cmdframe.new -text "New Game" -command newgame
pack .cmdframe.new -side left


#
# Canvas
#

canvas .canvas -width 300 -height 400
pack .canvas -expand yes -fill both 

set pdlwd 50
set pdlhg 10
set ballsz 14
set vel 10
set speed 10
set brickheight 15
set brickwidth 20
set bricksperline 10
set linesofbricks 5
set dx 5
set dy 5
set state stopped

proc initwalls {} {
	global wdt hgt left right top bottom	
	scan [winfo geometry .canvas] "%dx%d" wdt hgt
	set left 0
	set top 0
	set right [expr $wdt-1]
	set bottom [expr $hgt-1]
	.canvas create rectangle $left $top $right $bottom
}

proc addbrick { x0 y0 x1 y1 } {	
	set name "brk$x0$y0"
	.canvas create rectangle $x0 $y0 $x1 $y1 -tags "$name"
}
	

proc initbricks {} {
	global wdt hgt left right top
	global bricksperline brickheight brickwidth linesofbricks

	for {set y [expr $top+$brickheight]; set n 0} \
	    {$n<$linesofbricks} \
	    {incr y [expr $brickheight+1]; incr n} {
		for {set x [expr $left+1]} \
		    {$x+$brickwidth<$right} \
		    {incr x [expr $brickwidth+1]} {
			addbrick $x $y [expr $x+$brickwidth] \
				       [expr $y+$brickheight]
		}
	}
}
	
proc newgame {} {
	global wall ball paddle 
	global wdt hgt left right top bottom
	global ballx bally ballsz 
	global pdlwd pdlhg pdly
	global state
	if {$state == "active"} return
	.canvas delete all
	initwalls
	initbricks
	set ballx [expr ($left+$right-$ballsz)/2] 
	set bally [expr ($top+$bottom-$ballsz)/2]
	set ball [.canvas create oval $ballx $bally [expr $ballx+$ballsz-1] \
		  [expr $bally+$ballsz-1] -fill blue -tags ball]
	set pdly [expr $bottom-$pdlhg]
	set paddle [.canvas create line $left $pdly [expr $left+$pdlwd-1]\
		   $pdly -width $pdlhg -tags paddle]
	.canvas create rectangle $left [expr $bottom-100] $right\
		 [expr $bottom-50] -fill white
	randomdir 45 135	
	set state active
	bind .canvas <Any-Motion> { pdlmove %x }
	grab set -global .canvas
	after 1000 moveball
}

proc stop {} {
	global state
	set state "stopped"
	bind .canvas <Any-Motion> {}
	grab release .canvas
}

proc random {} {
     global seed
     if ![info exists seed] {
        set seed [pid]
     }
     set seed [expr ($seed * 4676) % 414971]
}

proc randomdir { minang maxang } {
	global dx dy vel
	set ang [expr ([random]%($maxang-$minang)+$minang)*3.1416/180]
	set dx [expr $vel*cos($ang)]
	set dy [expr $vel*sin($ang)]
}
	
proc brickhit { x0 y0 x1 y1 } {
	global ballx bally ball dx dy

	if {($dy>0 && 
	    [lsearch [.canvas find overlapping $x0 $y0 $x1 $y0] $ball]>=0) ||
	    ($dy<0 &&	
	    [lsearch [.canvas find overlapping $x0 $y1 $x1 $y1] $ball]>=0)} {
		set dy [expr -$dy]
	}

	if {($dx>0 && 
	    [lsearch [.canvas find overlapping $x0 $y0 $x0 $y1] $ball]>=0) ||
	    ($dx<0 &&
	    [lsearch [.canvas find overlapping $x1 $y0 $x1 $y1] $ball]>=0)} {
		set dx [expr -$dx]
	}
}

proc paddlehit {} {	
	set ballcrds [.canvas coords ball]
	set paddlecrds [.canvas coords paddle]
	set x0 [lindex $paddlecrds 0]
	set x1 [lindex $paddlecrds 2]
	set xsiz [expr $x1-$x0]
	set x [expr ($x0+$x1)/2]
	set xb [expr ([lindex $ballcrds 0]+[lindex $ballcrds 2])/2]
	set dev [expr int(($xb-$x)*90/$xsiz+270)]
	randomdir [expr $dev-5] [expr $dev+5]
}

proc hittest { hitobjects } {
	global dx dy state
	foreach obj $hitobjects {
		foreach tag [.canvas gettags $obj] {
			switch -glob $tag {
				paddle	{ if {$dy>0} paddlehit }
				brk* 	{ set crds [.canvas coords $tag] 
					  eval "brickhit $crds"	
					  .canvas delete $tag	
					}
			}
		}
	}
}

proc moveball {} {
	global dx dy ballx bally left right top bottom state speed
	if {$state=="stopped"} return
	.canvas move ball $dx $dy
	set crds [.canvas coords ball]
	if {$dx<0 && [lindex $crds 0] <= $left || 
	    $dx>0 && [lindex $crds 2] >= $right} {
		set dx [expr -$dx] 
	}
	if {$dy<0 && [lindex $crds 1] <= $top} {	
		set dy [expr -$dy]
	}
	if {$dy>0 && [lindex $crds 3] >= $bottom} {	
		puts "OUT"
		stop
		return
	}
	
	hittest [eval ".canvas find overlapping $crds"]	
	if {$state == "active"} { after $speed moveball }
}

proc pdlmove { x } {
	global pdlwd pdly
	.canvas coords paddle [expr $x-$pdlwd/2] $pdly \
			      [expr $x+$pdlwd/2] $pdly 
}

}] eval
