#! /project/tools/bin/mips/otcl

#
# Copyright (c) 1994 Open Software Foundation, Inc.
# 
# Permission is hereby granted to use, copy, modify and freely distribute
# the software in this file and its documentation for any purpose without
# fee, provided that the above copyright notice appears in all copies, and
# that both the copyright notice and this permission notice appear in
# supporting documentation.  Further, provided that the name of Open
# Software Foundation, Inc. ("OSF") not be used in advertising or
# publicity pertaining to distribution of the software without prior
# written permission from OSF.  OSF makes no representations about the
# suitability of this software for any purpose.  It is provided "AS IS"
# without express or implied warranty.
#

# otAdmin.tcl
# OT administration
############################################################################
# otFilename <number>	  - return filename corr. to number for current proj
# otNewLog		  - start a new log file
# otCheckKwikPix <proj>   - check otKwikPix server for <proj>, restart if nec
# otRestartKwikPix <proj> - restart otKwikPix server for <proj> uncondit-lly
#

# otFilename <number>
# Return filename corresponding to number.
proc otFilename { number } {

    set numStr [format "%06u" $number]
    regsub (..).... $numStr \\1 top
    regsub ..(..).. $numStr \\1 mid
    regsub ....(..) $numStr \\1 bot

    return [format "%s/%s/d%s/d%s/c%s%s%s" [project projectDirectory] [project] $top $mid $top $mid $bot]

}

proc otMatchingFilesLs { number } {

    set numStr [format "%06u" $number]
    regsub (..).... $numStr \\1 top
    regsub ..(..).. $numStr \\1 mid
    regsub ....(..) $numStr \\1 bot

    if { [catch [list cd [format %s/%s/d%s/d%s [project projectDirectory] [project] $top $mid]] msg] } {
	error [format "No %s %d found" [project objectName] $number]
    }
    if { [catch [list glob [format "c%s%s%s*" $top $mid $bot]] fileNames] } {
	error [format "No %s %d found" [project objectName] $number]
    }
    if { [catch [concat exec ls -l $fileNames] msg] } {
	error [format "No %s %d found" [project objectName] $number]
    } else {
	return $msg
    }
    
}

# otNewLog 
# Make new serverV3.log.  Save the current log and remove others.
proc otNewLog { } {

# Eventually these should be project-specific, not server-machine specific.
    set logDir /project/ot
    set logName serverV3.log

    if { [catch [list cd $logDir] msg] } { return $msg }

    set r [catch [list glob [format {%s.[0-9]*} $logName]] oldLogs]
    if { $r == 0 } {
	if { [catch [concat exec rm -f [concat $oldLogs]] msg] } {
	    return $msg
	}
    }

    if { [catch {exec /bin/date +%y%m%d} msg] } { 
	return $msg 
    } else {
	set datePrefix $msg
    }

    if { ![file exists $logName] } {
	return [format "no %s file found" $logName]
    }

    set mvMsg [format "exec mv %s %s.%s" $logName $logName $datePrefix]
    if { [catch $mvMsg msg] } {
	return $msg
    } else {
	return "ok"
    }

}

proc otScanLog { pat }  {

    set logDir /project/ot
    set logName serverV3.log
    set matches {}

    if { [catch [list cd $logDir] msg] } { return $msg }

    if { [catch [list open [format {|grep %s %s} $pat $logName] r] msg] } {
	error $msg
    }
    set fp $msg

    while { [gets $fp tmp] != -1 } {
	append matches $tmp \n
    }
    close $fp
    return $matches

}

proc otCheckKwikPix { projectName } {

    set kwikPixRunning {}
    set psfp [open "|ps laxw" r]
    while { [gets $psfp tmp] != -1 } {
	if { [string match {*otKwikPix*} $tmp] && 
	     [string match [format "*%s*" $projectName] $tmp]} {
	     set kwikPixRunning $tmp
	}
    }
    close $psfp
    
    if { $kwikPixRunning == {} } {
	set r [catch [list otRestartKwikPix $projectName] msg]
	if { $r == 0 } {
	    error $msg
	}
    } else {
	set msg [format "otKwikPix still running:\n%s" $kwikPixRunning]
    }

    return $msg

}


proc otRestartKwikPix { projectName } {

# This must be executed by root.
    set msg [project set $projectName]
    if { [string match {*not found} $msg] } {
	error $msg
    }

    set socketName [format "%s/%s/socket" [project projectDirectory] [project]]
    if { [catch [list exec rm -f $socketName] msg] } {
	error $msg
    }

    set fp [open [format "|/etc/otKwikPix -p%s" [project]] r]
    if { [catch [concat close $fp] msg] } {
	error $msg
    }

    return "otKwikPix restarted"

}


