#! /bin/sh

#
# Copyright (c) 1994 Open Software Foundation, Inc.
# 
# Permission is hereby granted to use, copy, modify and freely distribute
# the software in this file and its documentation for any purpose without
# fee, provided that the above copyright notice appears in all copies, and
# that both the copyright notice and this permission notice appear in
# supporting documentation.  Further, provided that the name of Open
# Software Foundation, Inc. ("OSF") not be used in advertising or
# publicity pertaining to distribution of the software without prior
# written permission from OSF.  OSF makes no representations about the
# suitability of this software for any purpose.  It is provided "AS IS"
# without express or implied warranty.
#

#
# Print a metrics report.
# Requires (check this list before executing):
#
#  - /project/ot is mounted from open (so in the case of
#	DCE project, the dce_inactive CRs are available for
#	closed bug counts
#  - the date_range program in /project/tools/bin/*
#
# Note that the metrics for the DCE project are a special case.
# Because of the counts on closed bug reports, which in the case of
# DCE are archived on open, and not on snoopy where the open CRs are,
# it is necessary to copy over the current open CR Sum files with the
# getDceSum.expect script.
#
# Output: countTable.out

set -x
PROJECT=motif
OT_BUGS=./ot_bugs
C="countTable"

# find dates for 30, 90, 180 days

# today=`date +%D`
# day030=`date_range -d  30 $today | sed -e '/^\(.*\)\-.*$/s//\1/'`
# day031=`date_range -d  31 $today | sed -e '/^\(.*\)\-.*$/s//\1/'`
# day090=`date_range -d  90 $today | sed -e '/^\(.*\)\-.*$/s//\1/'`
# day091=`date_range -d  91 $today | sed -e '/^\(.*\)\-.*$/s//\1/'`
# day180=`date_range -d 180 $today | sed -e '/^\(.*\)\-.*$/s//\1/'`

day030=-30
day031=-31
day090=-90
day091=-91
day180=-180

# The funny q variable was required to do the date substitution
# correctly and present the otBugsString as one argument following
# the -x flag of ot_bugs.

q='"'

# This is difficult to read in 80 columns but in 160 columns
# it makes the table short and easy to understand.
#
otBugsString="[\
$C $q  1 Open CRs by severity and priority$q    {sever prior}    ${q}[crtype def] && [area code] && [stat open]$q  ; \
$C $q  2 Open CRs by component and priority$q   {comp prior}     ${q}[crtype def] && [area code] && [stat open]$q  ; \
$C $q  3 Open CRs without assignment$q          {comp prior}     ${q}[crtype def] && [area code] && [stat open] && [code $q$q]$q  ; \
$C $q  4 Closed CRs by component and priority$q {sever comp prior} ${q}[crtype def] && [area code] && [stat closed]$q  ; \
$C $q  5 Aging - CRs closed in last 30 days$q   {prior}          ${q}[crtype def] && [area code] && [stat closed] && [cdate >$day030]$q ; \
$C $q    31-90 days$q                           {prior}          ${q}[crtype def] && [area code] && [stat closed] && [cdate $day090-$day031]$q ; \
$C $q    91-180 days$q                          {prior}          ${q}[crtype def] && [area code] && [stat closed] && [cdate $day180-$day091]$q ; \
$C $q    180 days ago$q                         {prior}          ${q}[crtype def] && [area code] && [stat closed] && [cdate <$day180]$q ; \
$C $q  6 Aging - CRs open for the last 30 days$q {prior}          ${q}[crtype def] && [area code] && [stat open]   && [rdate >$day030]$q ; \
$C $q    for 31-90 days$q                       {prior}          ${q}[crtype def] && [area code] && [stat open]   && [rdate $day090-$day031]$q ; \
$C $q    for 91-180 days$q                      {prior}          ${q}[crtype def] && [area code] && [stat open]   && [rdate $day180-$day091]$q ; \
$C $q    before 180 days ago$q                  {prior}          ${q}[crtype def] && [area code] && [stat open]   && [rdate <$day180]$q ; \
$C $q  7 Total bugs by discovery method$q       {how prior}      ${q}[crtype def] && [area code] $q ; \
$C $q  8 Total bugs by reporting company$q      {rbycomp prior}  ${q}[crtype def] && [area code] $q ; \
$C $q  9 Totals CRS both opened and closed within 30 days$q {prior}          ${q}[crtype def] && [area code] && [stat closed] && [rdate >$day030]$q]"

$OT_BUGS -p"$PROJECT" -F /project/ot/lib/countTable.tcl -x "$otBugsString" > countTableMotif.out
exit


