/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 *	otCLI.c
 *
 */

/*
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <pwd.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"


#ifndef LINT
static char RCSid_otCLI[] =
    "$RCSfile: otCLI.c,v $ $Revision: 1.1.7.1 $ $Date: 1994/01/19 18:08:52 $";
#endif


/* getopt() command line details */

/* command line options for getopt() */
#define optString "a:dekn:p:stuvx:"     /* for the "ot" command */
#define optQryString "a:cdefhk:l:mn:o:p:qrs:tw:x:" /* for the "ot_bugs" */

/*
 *              List of functions defined in the otUtil.c
 *
 *		otEditForCLI()
 *		otParseArgsCLI()
 *
 */

OTErr
otParseArgsCLI(argc, argv)
int argc;
char * argv[];
{
    register int  i, opt;
    OTErr errCode = SUCCESS;
#ifdef notdef
    char *fileStr;
    Tcl_Interp *interp;
#endif

    while ( (opt = getopt(argc, argv, optString)) != EOF )	{

	switch ( opt )	{

	case 'd':
		if (otCB->cb_operation != INITIAL) 
		    errCode = OT_OTCLI_USAGE;
		else
		    errCode = otSetCBMember("operation", "DELETE");
		break;

	case 'e':
		if (otCB->cb_operation != INITIAL) 
		    errCode = OT_OTCLI_USAGE;
		else
		    errCode = otSetCBMember("operation", "ENTER");
		break;

	case 'u':
		if (otCB->cb_operation != INITIAL) 
		    errCode = OT_OTCLI_USAGE;
		else
		    errCode = otSetCBMember("operation", "UPDATE");
		break;

	case 'v':
		if (otCB->cb_operation != INITIAL)
		    errCode = OT_OTCLI_USAGE;
		else
		    errCode = otSetCBMember("operation", "VALIDATE");
		break;

	case 'p':
		errCode = OT_INTERNAL_ERROR;
		otPutPostedMessage(OT_INTERNAL_ERROR, 
	    	            "otPreparseInput while extracting a project name");
		break;

	case 'n':  
		if (otCB->cb_CRNumber)
		    errCode = OT_OTCLI_USAGE;
		else
		    errCode = otSetCBMember("CRNumber", optarg);
		break;

	case 's':
		errCode = otSetCBMember("notify", "off");
		break;

	case 't':
		if (otCB->cb_operation != INITIAL)
		    errCode = OT_OTCLI_USAGE;
		else
		    errCode = otSetCBMember("operation", "TEMPLATE");
		break;

	case 'a':
		errCode = OT_INTERNAL_ERROR;
		otPutPostedMessage(OT_INTERNAL_ERROR,
	   "otPreparseInput while extracting an alternate meta template name");
		break;

	case 'k':
		errCode = otSetCBMember("append", "on");
		break;

	case 'x': 
		errCode = otSetCBMember("tclString", optarg);
		break;
		
#ifdef notdef
	case 'F':
		if ( errCode = otWriteFileToString(optarg, &fileStr) ) {
		    if ( errCode == OT_STAT )
			otPutPostedMessage(OT_STAT, optarg);
		} else {
		    errCode = otSetCBMember("tclFile", fileStr);

		    if ( interp = otCB->cb_pcb->pcb_interp ) {
			if (Tcl_Eval(interp, fileStr)) {
			    otPutPostedMessage( OT_TCL, interp->result );
			    errCode = OT_TCL;
			}
		    }
		    free(fileStr);
		}
		break;
#endif

	case '?':
		errCode = OT_OTCLI_USAGE;
		break;
	}
    }


/* process remaining args (template filename) */

    for (i=optind;  (i < argc) && !errCode;  i++)	{
	if (otCB->cb_templFile)
	    errCode = OT_OTCLI_USAGE;
	else {
	    if ( strlen(argv[i]) > LONGVALUE ) {
		errCode = OT_TEMPLATE_NAME;
		otPutPostedMessage(OT_TEMPLATE_NAME);
	    }
	    else
		errCode = otSetCBMember("templFile", argv[i]);
	}
    }

    if ((errCode == OT_OTCLI_USAGE) || (argc != i) || 
				    (otCB->cb_operation == INITIAL)) {
	errCode = OT_OTCLI_USAGE;
	otPutPostedMessage(OT_OTCLI_USAGE, argv[0]);
    }

    return errCode;
}



OTErr
otEditForCLI(tmpfile)
char    *tmpfile;
{
    OTErr errCode = OT_SUCCESS;

    /* Write template structure to a temporary file for edit */
    tmpfile[0] = 0;
    tmpnam(tmpfile);
    strcpy(rmTfile, tmpfile);

    errCode = otWriteTemplateToFilename(otCB->cb_ecb->ecb_origStruct, tmpfile);
    if (errCode)
	return errCode;

    /* Allow user edit */
    otCatchSignals(1);	/* Ignore signals in editor */

    errCode = otEditTemplate(tmpfile);
    if (errCode) {
	otCatchSignals(2);
	return errCode;
    }
    otCatchSignals(2);	/* Catch signals now */

    return errCode;
}


/*
 *                 o t V a l i d a t e E d i t C L I
 *
 *
 */
OTErr
otValidateEditCLI(template)
char * template;           /* name of template file to read */
{
    bool justClosed, ignoreErr, tclError, valid;
    FILE *fp;
    char *cp, *origstat, *currstat;
    long id = 0;
    OTTemplate *tStruct = otCB->cb_ecb->ecb_tStruct;
    OTTemplate *origStruct = otCB->cb_ecb->ecb_origStruct;
    OTOperation  operation = otCB->cb_operation;
    OTProject * pStruct = otCB->cb_pcb->pcb_project;
    long        CRNumber = otCB->cb_pcb->pcb_CRNumber;
    char      * ott_pstr = otCB->cb_tclString;

    OTErr errCode, errRet;


    DBUG_MED((stderr, "otValidateEditCLI template %s\toperation %d\n", template, operation));
    DBUG_MED((stderr, "for proj %s\tCRnum %d\t\n", pStruct->name, CRNumber));


    while (TRUE) {
	valid = TRUE;
	justClosed = FALSE;
	ignoreErr = FALSE;
	tclError = FALSE;
	errCode = errRet = OT_SUCCESS;

    /* Refresh tStruct from the context of the updated template file */

        if (tStruct) {
	    otFreeTemplate(tStruct);
	    otCB->cb_ecb->ecb_tStruct = 0;
	}
	errCode = otReadTemplateFromFilename(&tStruct, template, TRUE, FALSE);
	if (errCode) {
	    errRet = errCode;
	    break;	    
	}

	otCB->cb_ecb->ecb_tStruct = tStruct;

	if (otCB->cb_templFile || otCB->cb_tclString) {
	    errCode = otCollateTemplate( &(otCB->cb_ecb->ecb_tStruct) );
	    if ( OT_WARN( errCode ) || OT_SYSTEM( errCode ) ) {
	        errRet = errCode;
		break;
	    }
	    else
	        errCode = OT_SUCCESS;
	}

	if (otCB->cb_tclString && 
	    ((errRet = otTclEval(otCB->cb_tclString)) != OT_SUCCESS)) {
  	    valid = FALSE;
	    break;
	}

    /* First check if template is unchanged. */

	if ( !otCB->cb_pcb->pcb_forceUpdate ) {
	    errCode = otTemplateChanged();
	    if ( errCode ) {
		errRet = errCode;
		break;
	    }
	}

    /* The check for valid CR Number field should be a part of the 
       ValidateData() */

	if ( (operation == ENTER) && (otGetIDNumValue(tStruct) != 1000000) ) {
	    valid = FALSE;
	    otPutPostedMessage(OT_NUMBER_PLACE_HOLDER, pStruct->object_name);
	}

	if (operation == UPDATE) {
	    if ( !(id = otGetIDNumValue(tStruct)) || (CRNumber != id) ) {
		if (id == 1000000)
		    id = 0;
		valid = FALSE;
		otPutPostedMessage(OT_DIFFERENT_NUMBER, pStruct->object_name, 
		    		id, pStruct->object_name, CRNumber);
	    }
	}

	DBUG_MIN((stderr, "otmain: validation\n"));

	/*
	 * Note that simple validation errors will continue to accumulate
	 * so all errors are detected on one pass: only warnings and system
	 * errors cause a break.
	 */

	errCode = otValidateLhs();
	if ( errCode ) {
	    valid = FALSE;
	    if ( OT_WARN(errCode) || OT_SYSTEM(errCode) ) {
		errRet = errCode;
		break;
	    }
	}

	errCode = otValidateData();
	if (errCode) { 
	    valid = FALSE;
	    if ( OT_WARN(errCode) || OT_SYSTEM(errCode) ) {
		errRet = errCode;
	        break;
	    }
	}

	errCode = otValidateDepend();
        if (errCode) {
	    valid = FALSE;
	    if ( OT_WARN(errCode) || OT_SYSTEM(errCode) ) {
		errRet = errCode;
	        break;
	    }

	}

    /* Do not re-edit if validated successfully */

	if (valid)  {
	    break;  /* passed */
	}

    /* Print out all validation errors */
	cp = otGetPostedMessage();
	fprintf(stderr, "%s\n", cp);


    /* Do not re-edit if template is passed */
	if (otCB->cb_templFile || ott_pstr)
	    break;

	fprintf(stderr, "\npress RETURN to re-edit template\n");
	while (getchar() != '\n') ;

	otCatchSignals(1);       /* ignore signals in editor */

    /* Allow user edit */
	errCode = otEditTemplate(template);
	if (errCode) {
	    otCatchSignals(2);
	    break;
	}

	otCatchSignals(2);       /* catch signals otherwise */
    }

    currstat = otGetHeaderFieldValue( "Status", tStruct );
    if (currstat) {
        if ( (operation == ENTER) && ( !strcmp(currstat, "closed") ) )
	    justClosed = TRUE;
        if ( ( operation == UPDATE ) && 
		(origstat = otGetHeaderFieldValue( "Status", origStruct )) ) {
	    if ( strcmp(origstat, "closed") && !strcmp(currstat, "closed") )
	        justClosed = TRUE;
        }
    }

    if (justClosed && valid)
	otCB->cb_pcb->pcb_operation = CLOSE; /* spec. "derived" operation */

    if (!valid && !errRet && !ignoreErr) {
	errRet = OT_INVALID;
    }
    return errRet;
}



OTErr
otParseQryArgsCLI(ac, av)
int ac;                 /* argc */
char * av[];            /* argv */
{
    register int i, opt;
    OTErr errCode = OT_SUCCESS;
    char *fileStr;
    Tcl_Interp *interp;

    while ( ((opt = getopt(ac, av, optQryString)) != EOF) && !errCode )	{

	switch ( opt )	{

	case 'a':    /* alternate template is already handled */
		errCode = OT_INTERNAL_ERROR;
		otPutPostedMessage(OT_INTERNAL_ERROR,
	     "otParseQryArgsCLI - unexpected alternate meta template argument");
		break;    

	case 'c':	/* don't print column headings */
		errCode = otSetQCBMember("skipHeader", "TRUE"); 
		break;

	case 'd':	/* print help details message */
	        otDoHelpDetails();
		otCleanAfterQuery();
		otFreeControlBlock();
		exit(0);
		break;

	case 'e':	/* count (entire count) */
		errCode = otSetQCBMember("count", "TRUE");
		break;

	case 'f':	/* print full text of CRs */
		errCode = otSetQfullText("TRUE");
		break;

	case 'h':	/* print help message */
	        otDoHelp();
		otCleanAfterQuery();
		otFreeControlBlock();
		exit(0);
		break;

	case 'k':	/* search for key string in note text */
		errCode = otSetQCBMember("keyInText", optarg);
		break;

	case 'l':	/* print using alternate layout */
		errCode = otSetQlayout(optarg);
		break;

	case 'm':	/* print metrics (count and summary) */
		errCode = otSetQmetrics("TRUE");
		break;

	case 'n':	/* print a specific CR (by number) */
		errCode = otSetQCRNumber(optarg);
		break;

	case 'o':	/* order (sort) by named field */
		errCode = otSetQCBMember("sortField", optarg);
		break;

	case 'p':	/* project is already handled */
		errCode = OT_INTERNAL_ERROR;
		otPutPostedMessage(OT_INTERNAL_ERROR,
		"otParseQryArgsCLI - unexpected project argument");
		break;		

	case 'q':	/* quiet! */
		otCB->cb_pcb->pcb_quiet = TRUE;
		break;

	case 'r':	/* print revision history for CRs in long report */
		errCode = otSetQhistory("TRUE");
		break;

	case 's':	/* specify CR selection criteria */
		errCode = otSetQselect(optarg);
		break;

	case 't':	/* separate columns by tabs */
		errCode = otSetQCBMember("tabSeparate", "TRUE");
		break;

	case 'w':	/* print with specified width */
		errCode = otSetQCBMember("outwidth", optarg);
		break;

	case 'x': 
		errCode = otSetCBMember("tclString", optarg);
		break;

#ifdef notdef
	case 'F':
		errCode = otWriteFileToString(optarg, &fileStr);
		if ( errCode ) {
		    if ( errCode == OT_STAT )
			otPutPostedMessage(OT_STAT, optarg);
		} else {
		    errCode = otSetCBMember("tclFile", fileStr);

		    interp = otCB->cb_pcb->pcb_interp;
		    if ( interp ) {
			if (Tcl_Eval(interp, fileStr)) {
			    otPutPostedMessage( OT_TCL, interp->result );
			    errCode = OT_TCL;
			}
		    }
		    free(fileStr);
		}
		break;
#endif

	case '?':
		errCode = OT_OTB_CLI_USAGE;
		otPutPostedMessage(OT_OTB_CLI_USAGE, *av);
		break;
	}
    }

    for (i=optind;  (i < ac) && !errCode;  i++)    {
	if (otCB->cb_templFile) {
	    errCode = OT_ONE_FILENAME_ONLY;
	    otPutPostedMessage(OT_ONE_FILENAME_ONLY, optarg);
	}
	else {
	    struct stat stat_buf;

	    if ( !(errCode = otSetCBMember("templFile", av[i])) &&
	          (strcmp( "-", otCB->cb_templFile)) )  {

	        if (stat(otCB->cb_templFile, &stat_buf) != 0) {
		    errCode = OT_STAT;
		    otPutPostedMessage(OT_STAT, otCB->cb_templFile);
		}
		else if (!(stat_buf.st_mode & S_IFREG)) {
		    errCode = OT_NOT_REGULAR_FILE;
		    otPutPostedMessage(OT_NOT_REGULAR_FILE, otCB->cb_templFile);
		}
	    }
	}
    }
    return errCode;
}
