#
# artlist.tcl
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

#
# ArticleListDialog
#
# Public attributes:
#   -closecommand	command when quit is selected
#   -title		title
#
# Methods:
#
itcl_class ArticleListDialog \
{
  constructor {config} \
  {
    #
    #  Create a window with the same name as this object
    #
    set class [$this info class]
    ::rename $this $this-tmp-
    ::toplevel $this -class $class
    ::rename $this $this-win-
    ::rename $this-tmp- $this
    wm title $this $title

    set article_list [MultiColumnList $this.groups 3 \
		{Stat Subject Author} -size 5x10 \
		-select_command "$this clickArticle" \
		-doubleclick "$this doubleClickArticle"]
    $article_list setWidth 0 3
    $article_list setWidth 1 40
    $article_list setWidth 2 20
    pack $article_list -expand yes -fill both

    entry $this.info -width 40
    pack $this.info -side top -fill x

    frame $this.buttons -relief sunken -bd 1
    button $this.buttons.read -text "Read.." -width 8 \
		-command "$this read"
    button $this.buttons.uudecode -text "Uudecode" -width 8 \
		-command "$this uudecode"
    button $this.buttons.close -text "Close" -width 8 \
		-command "$this close"
    pack $this.buttons.read $this.buttons.uudecode \
	-side left -padx 3 -pady 2
    pack $this.buttons.close -side right -padx 3 -pady 2
    pack $this.buttons -side top -fill x

    wm protocol . WM_DELETE_WINDOW "$this close"
  }

  destructor \
  { ::rename $this-win- {} }

  method config {config} {}

  method read {} \
  { if {$current_article != ""} \
    { if {$article_dialog == ""} \
      { set article_dialog [ArticleDialog $this.article_dialog \
		-title "Article" -main $main -article_list $this \
		-closecommand "wm withdraw $this.article_dialog"]
      } \
      else \
      { wm deiconify $article_dialog }
      $article_dialog showArticle $current_group $current_article
      $group_stat addArticle $current_group $current_article
    }
  }

  method uudecode {} \
  {
    set nntp_socket [$main getNntpSocket]
    if {$nntp_socket != ""} \
    { showInfo "saving article..."
      dp_send $nntp_socket "group $current_group"
      gets $nntp_socket line
      set tmp_file "/tmp/flash[pid]"
      set fp [::open $tmp_file w]
      dp_send $nntp_socket "article $current_article"
      gets $nntp_socket line
      if {[lindex $line 0] != "220"} \
      { show_error $this [string range 4 end [string trimright $line]]
      } \
      else \
      { set done 0
        while {$done == 0} \
        { gets $nntp_socket line
          set line [string trimright $line]
          if {$line == "."} \
          { set done 1 } \
          else \
          { puts $fp $line }
        }
        ::close $fp
        showInfo "uudecoding..."
        if [catch {exec uudecode $tmp_file} msg] \
        { show_error $this "Uudecode Error" $msg }
        exec rm $tmp_file
        showInfo ""
      }
    }

  }

  method close {} \
  { eval $closecommand }

  method showInfo {message} \
  { $this.info delete 0 end
    $this.info insert 0 $message
    update
  }

  method clickArticle {row} \
  { set current_article $article_numbers($row)
    set current_row $row
  }

  method doubleClickArticle {row} \
  { set current_article $article_numbers($row)
    set current_row $row
    read
  }

  method showGroupArticles {group_name} \
  { wm title $this "$title - $group_name"
    $article_list clearAllColumns
    set current_group $group_name
    set article_numbers(0) ""
    unset article_numbers
    set art_subject(0) ""
    unset art_subject
    set art_from(0) ""
    unset art_from
    set art_messageid(0) ""
    unset art_messageid
    set art_reference(0) ""
    unset art_reference
    set nntp_socket [$main getNntpSocket]
    if {$nntp_socket != ""} \
    { dp_send $nntp_socket "group $current_group"
      gets $nntp_socket line
      set line [string trim $line]
      set start [$group_stat getLast $group_name]
      set end [lindex $line 3]
      getXhdr $nntp_socket $start $end subject setSubject
      getXhdr $nntp_socket $start $end from setFrom
#      getXhdr $nntp_socket $start $end Message-Id setMessageId
#      getXhdr $nntp_socket $start $end References setReference
      set row 0
      set numbers [array names art_subject]
      foreach number $numbers \
      { $article_list addRow [list "" $art_subject($number) \
			$art_from($number)]
        set article_numbers($row) $number
        incr row
      }
      set no_of_rows $row
    }
  }

  method getXhdr {nntp_socket start end field callback} \
  { dp_send $nntp_socket "xhdr $field $start-$end"
    gets $nntp_socket line
    set status [lindex $line 0]
    if {$status < 300} \
    { set done ""
      while {$done == ""} \
      { gets $nntp_socket line
        set line [string trimright $line]
        if {$line == "."} \
        { set done 1} \
        else \
        { set number [lindex $line 0]
          set value [string range $line [string length $number] end]
          $callback $number $value
        }
      }
    }
  }

  method setSubject {number value} \
  { set art_subject($number) $value }

  method setFrom {number value} \
  { set art_from($number) $value }

  method setMessageId {number value} \
  { set art_messageid($value) $number }

  method setReference {number value} \
  { set art_reference($number) $value }

  method setGroup {group_name} \
  { wm title $this "$title - $group_name"
    set current_group $group_name
    set article_numbers(0) ""
    unset article_numbers
    set nntp_socket [$main getNntpSocket]
    if {$nntp_socket != ""} \
    { dp_send $nntp_socket "group $current_group"
      gets $nntp_socket line
      set line [string trim $line]
      set start [lindex $line 2]
      set end [lindex $line 3]
      set row 0
      set done 0
      while {$done == 0} \
      { dp_send $nntp_socket "head"
        set head_done 0
        set subject ""
        set author ""
        gets $nntp_socket line
        set status [lindex $line 0]
        if {$status != "221"} \
        { set done 1 } \
        else \
        { set head_done 0
          set number [lindex $line 1]
          while {$head_done == 0} \
          { gets $nntp_socket line
            set line [string trim $line]
            if {$line == "."} \
            { set head_done 1 } \
            else \
            { set word [lindex $line 0]
              switch -- $word \
              { "Subject:" { set subject [string range $line 9 end] }
                "From:" { set author [string range $line 6 end] }
              }
            }
          }
          $article_list addRow [list $subject $author]
          set article_numbers($row) $number
          incr row
          dp_send $nntp_socket "next"
          gets $nntp_socket line
          set status [lindex $line 0]
          if {$status != "223"} \
          { set done 1 }
        }
      }
    }
  }

  method takeFocus {} \
  {
  }

  public closecommand ""
  public main ""
  public title ""
  public group_stat ""

  protected article_list ""
  protected current_group ""
  protected current_article ""
  protected current_row ""
  protected no_of_rows 0
  protected article_numbers
  protected article_dialog ""
  protected art_subject
  protected art_from
  protected art_messageid
  protected art_reference
}




