# jfileio.tcl - read and write text to files
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# write given text to a file
######################################################################

proc j:fileio:write { filename text } {
  set file [open $filename w]
  puts -nonewline $file $text
  close $file
}

######################################################################
# return contents of file
######################################################################

proc j:fileio:read { filename } {
  set file [open $filename r]
  set result [read $file]
  close $file
  
  return $result
}
