# jcompose.tcl - support for the Compose (Multi_key) key
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

# this is used by jtextkeys.tcl and jentrykeys.tcl
# TO DO: generalise to other character sets
# merge entry and text procs - check class of window!

######################################################################
# j:tc:start_sequence W K A -
#   begin a compose sequence.  bring in the compose key table if 
#   necessary.
######################################################################

proc j:tc:start_sequence { W K A } {
  global j_cmp
  
  set j_cmp(first,$W) $A
  
  if {![info exists j_cmp(iso8859-1)]} {
    j:compose_init:iso8859-1
  }
}

######################################################################
# j:tc:finish_sequence W K A -
#   finish a compose sequence.
######################################################################

proc j:tc:finish_sequence { W K A } {
  global j_cmp
  
  if {![info exists j_cmp(iso8859-1)] ||
      ![info exists j_cmp(first,$W)]} {
    error [j:ldb j:tc:finish_before_start \
      {j:tc:finish_sequence called before j:tc:start_sequence}]
  }
  
  set pair [join [lsort -ascii [list $j_cmp(first,$W) $A]] {}]
  catch {
    j:tkb:process_key \
      $W {} $j_cmp(iso8859-1,keysym,$pair) $j_cmp(iso8859-1,glyph,$pair)
  }
}

######################################################################
# j:ec:start_sequence W K A -
#   begin a compose sequence.  bring in the compose key table if 
#   necessary.
######################################################################

proc j:ec:start_sequence { W K A } {
  global j_cmp
  
  set j_cmp(first,$W) $A
  
  if {![info exists j_cmp(iso8859-1)]} {
    j:compose_init:iso8859-1
  }
}

######################################################################
# j:ec:finish_sequence W K A -
#   finish a compose sequence.
######################################################################

proc j:ec:finish_sequence { W K A } {
  global j_cmp
  
  if {![info exists j_cmp(iso8859-1)] ||
      ![info exists j_cmp(first,$W)]} {
    error [j:ldb j:ec:finish_before_start \
      {j:ec:finish_sequence called before j:ec:start_sequence}]
  }
  
  set pair [join [lsort -ascii [list $j_cmp(first,$W) $A]] {}]
  catch {
    j:ekb:process_key \
      $W {} $j_cmp(iso8859-1,keysym,$pair) $j_cmp(iso8859-1,glyph,$pair)
  }
}

