# jprefpanel.tcl - preference panel(s) and related tools
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# global variables:
#
global J_PREFS env
j:default J_PREFS(autoposition) 0
j:default J_PREFS(confirm) 1
#
######################################################################


######################################################################
# j:global_pref_panel ?options? - preferences panel for ~/.tk/defaults
# options include
#   -title - title of toplevel window
### ADD COLOURS?
######################################################################

proc j:global_pref_panel { args } {
  global env tk_strictMotif J_PREFS
  j:parse_args { {title title:prefs} }
  
  set title [uplevel 1 [list j:ldb $title]]
  
  set tl .prefs
  
  toplevel $tl
  wm title $tl $title

  frame $tl.language
  label $tl.language.l -text [j:ldb prefs:language]
  entry $tl.language.e -width 25 \
    -textvariable J_PREFS(language)
  checkbutton $tl.autoposition -anchor w \
    -text [j:ldb prefs:autoposition] \
    -variable J_PREFS(autoposition)
  checkbutton $tl.confirm -anchor w \
    -text [j:ldb prefs:confirm] \
    -variable J_PREFS(confirm)
  checkbutton $tl.j_fs_fast -anchor w \
    -text [j:ldb prefs:j_fs_fast] \
    -variable J_PREFS(j_fs_fast)
  checkbutton $tl.motif -anchor w \
    -text [j:ldb prefs:tk_strictMotif] \
    -variable J_PREFS(tk_strictMotif)
  checkbutton $tl.scrollbarside -anchor w \
    -text [j:ldb prefs:scrollbarside] \
    -variable J_PREFS(scrollbarside) \
    -onvalue left -offvalue right
  checkbutton $tl.visiblebell -anchor w \
    -text [j:ldb prefs:visiblebell] \
    -variable J_PREFS(visiblebell)
  checkbutton $tl.audiblebell -anchor w \
    -text [j:ldb prefs:audiblebell] \
    -variable J_PREFS(audiblebell)
  
  frame $tl.horizontal
  
  frame $tl.bindings
  label $tl.bindings.l -text [j:ldb {Keyboard Bindings:}]
  radiobutton $tl.bindings.basic -anchor w \
    -text [j:ldb prefs:basic] \
    -variable J_PREFS(bindings) -value basic
  radiobutton $tl.bindings.vi -anchor w \
    -text [j:ldb prefs:vi] \
    -variable J_PREFS(bindings) -value vi
  radiobutton $tl.bindings.edt -anchor w \
    -text [j:ldb prefs:edt] \
    -variable J_PREFS(bindings) -value edt
  radiobutton $tl.bindings.emacs -anchor w \
    -text [j:ldb prefs:emacs] \
    -variable J_PREFS(bindings) -value emacs
  checkbutton $tl.bindings.typeover -anchor w \
    -text [j:ldb prefs:typeover] \
    -variable J_PREFS(typeover)
  frame $tl.web
  label $tl.web.l -text [j:ldb {Web Browser:}]
  radiobutton $tl.web.mosaic -anchor w \
    -text [j:ldb prefs:mosaic] \
    -variable J_PREFS(web_browser) -value mosaic
  radiobutton $tl.web.netscape -anchor w \
    -text [j:ldb prefs:netscape] \
    -variable J_PREFS(web_browser) -value netscape
  radiobutton $tl.web.arena -anchor w \
    -text [j:ldb prefs:arena] \
    -variable J_PREFS(web_browser) -value arena
  radiobutton $tl.web.lynx -anchor w \
    -text [j:ldb prefs:lynx] \
    -variable J_PREFS(web_browser) -value lynx
  
  frame $tl.man
  label $tl.man.l -text [j:ldb {Man Page Viewer:}]
  radiobutton $tl.man.builtin -anchor w \
    -text [j:ldb prefs:man_builtin] \
    -variable J_PREFS(man_viewer) -value builtin
  radiobutton $tl.man.tkman -anchor w \
    -text [j:ldb prefs:man_tkman] \
    -variable J_PREFS(man_viewer) -value tkman
  radiobutton $tl.man.man -anchor w \
    -text [j:ldb prefs:man_man] \
    -variable J_PREFS(man_viewer) -value man
  frame $tl.printer
  label $tl.printer.l -text [j:ldb prefs:printer]
  entry $tl.printer.e -width 25 \
    -textvariable J_PREFS(printer)

  j:buttonbar $tl.b -default save -buttons [format {
    {
      save Save {
        j:write_prefs
        destroy %s
      }
    } {
      done Done {
        destroy %s
      }
    }
  } $tl $tl]
  
  pack $tl.language.l -in $tl.language -side left
  pack $tl.language.e -in $tl.language \
    -expand yes -side left -padx 5 -pady 5
  
  pack $tl.bindings.l \
    $tl.bindings.basic \
    $tl.bindings.vi \
    $tl.bindings.edt \
    $tl.bindings.emacs \
    $tl.bindings.typeover \
    -in $tl.bindings -side top -fill x -anchor n
  
  pack $tl.web.l \
    $tl.web.mosaic \
    $tl.web.netscape \
    $tl.web.arena \
    $tl.web.lynx \
    -in $tl.web -side top -fill x -anchor n
  
  pack $tl.man.l \
    $tl.man.builtin \
    $tl.man.tkman \
    $tl.man.man \
    -in $tl.man -side top -fill x -anchor n

  pack $tl.bindings -in $tl.horizontal -side left -expand yes -fill y
  pack [j:rule $tl.horizontal] -in $tl.horizontal -side left -fill y
  pack $tl.web -in $tl.horizontal -side left -expand yes -fill y
  pack [j:rule $tl.horizontal] -in $tl.horizontal -side left -fill y
  pack $tl.man -in $tl.horizontal -side left -expand yes -fill y
  
  pack $tl.printer.l -in $tl.printer -side left
  pack $tl.printer.e -in $tl.printer \
    -expand yes -side left -padx 10 -pady 10

  pack $tl.language -in $tl -side top -expand yes -fill x
  pack [j:rule $tl] -in $tl -side top -fill x
  pack $tl.autoposition \
    $tl.confirm \
    $tl.j_fs_fast \
    $tl.motif \
    $tl.scrollbarside \
    $tl.visiblebell \
    $tl.audiblebell \
    -in $tl -side top -expand yes -fill x
  pack [j:rule $tl] -in $tl -side top -fill x
  pack $tl.horizontal -in $tl -side top -expand yes -fill x
  pack [j:rule $tl] -in $tl -side top -fill x
  pack $tl.printer -in $tl -side top -expand yes -fill x
  pack [j:rule $tl] -in $tl -side top -fill x
  pack $tl.b -in $tl -side top -expand yes -fill x

  set old_focus [focus]			;# so we can restore original focus
  
  j:dialogue $tl			;# position in centre of screen

  focus $tl
  j:default_button $tl.b.save \
    $tl.language.e \
    $tl.printer.e \
    $tl
  
  j:tab_ring $tl.language.e $tl.printer.e

  bind $tl <Key-Tab> "focus $tl.language.e"
  update
  grab $tl
  tkwait window $tl
  j:tk3 {focus $old_focus}
  j:tk4 {focus -force $old_focus}	;# can't figure out a better way...
}









