#!/usr/local/bin/wish -f
#
# evap - essentially identical to the C version of sample!
#        Same as sample.tcl except we get our command line
#        parameters from the associative array %Options.
#        Also gets its PDT and MM data from the same files
#	 used by the C sample programs.
     
source "src/evap.tcl"

set IN [open "pdt/sample_pdt" "r"]
set PDT [read $IN]
close $IN

set IN [open "mm/sample.mm" "r"]
set MM [read $IN]
close $IN

set PDT [split $PDT \n]
set MM [string trimright $MM \n]
set MM [split $MM \n]

evap $PDT $MM;			# evaluate parameters
puts -nonewline "\nProgram name:\n  $Options(help)\n\n"

if { [info exists Options(verbose)] } { puts -nonewline "verbose = $Options(verbose)\n" }
puts -nonewline "command = \"$Options(command)\"\n"
puts -nonewline "scale_factor  = $Options(scale_factor)\n"
puts -nonewline "millisecond_update_interval = $Options(millisecond_update_interval)\n"
puts -nonewline "ignore_output_file_column_one = $Options(ignore_output_file_column_one)\n"
puts -nonewline "output = $Options(output)\n"
puts -nonewline "queue = $Options(queue)\n"
puts -nonewline "destination = $Options(destination)\n"
puts -nonewline "'list of' tty = \"[join [split $Options(tty) "\x1C"] {", "}]\"\n";

if { $argc > 0 } {
    puts -nonewline "\nFile names:\n  [join $argv { }]\n"
}

exit 0
