#!/usr/local/bin/perl
#
# SOL, 93/01/02
#

require "../src/evap.pl";

@PDT = (
	'PDT',
	'  parameter_description_table, pdt: file = stdin',
	'  message_module, mm: file = ./MM',
	'PDTEND no_file_list',
	);
@MM = (
       'prototype_application_interface, proai',
       '',
       '        Expermiment with a Unix command line interface via evap.',
       '',
       '          Example:',
       '',
       '            proai -pdt PDT -mm MM',
       '            proai < PDT',
       '.parameter_description_table',
       '        The file containing the PDT statements to experiment',
       '        with.  Note that since the default value is \'stdin\'',
       '        normal I/O redirection can be used.',
       '.message_module',
       '        The file containing the command\'s help text.',
   );

&evap( *PDT, *MM );		# evaluate parameters

open( IN, "<$opt_parameter_description_table" );

$_ = <IN>;			# read first input line 
@tokens = split( ' ', $_ );	# check first token of first line for PDT
$tokens[$[] =~ tr/[a-z]/[A-Z]/;
die "Not a PDT." if $tokens[$[] !~ 'PDT';

open( OUT, "|generate_pdt -output proai_pdt_out" );
print OUT $_;

while ( <IN> ) {
    print OUT $_;
}

close( OUT );

system ("
  cc -g -o proai -I/usr/local/include -L/usr/local/lib proai_template.c -levap;
  add_message_module  -mml libproaimm.a $opt_message_module;
  display_command_information -command ./proai -display_option full;
");
