#-----dv-----Menue zum setzen des Wertes, der als undefiniert erkannt wird-----

#------------------------------------------------------------------------------
# diagsetundefvalok {} Hilfsprozedur, die von diagsetundefval aufgerufen wird;
#                      prueft, ob der eingegebene string  eine Zahl ist
#                      schreibt den Wert fest oder gibt gegebenenfalls 
#                      eine Fehlermeldung aus
#                      path : pfad des diagsetundefval menues
#                      dp   : aktueller diagramm widgetpfad
#------------------------------------------------------------------------------
#
proc diagsetundefvalok {path dp} {

  # Status und Diagrammvariablen sichtbar machen
  #
  global diagdata status

  # testen und eventuell Fehlermeldung ausgeben
  #
  if {![isdouble $status($dp.undefvalbuffer)]} {
        focus $path.menu.input.input 
        nodoubleerr $status($dp.undefvalbuffer)
        Anmerkung: Hierhin wird nicht zurueckverzweigt
  } {
    # undef. Wert zurueckschreiben
    #
    set diagdata($dp.undefval) $status($dp.undefvalbuffer)
  }
}
 
#------------------------------------------------------------------------------
# diagsetundefval {} Prozedur, mit der ein (numerischer) Wert eingegeben werden
#                    kann, der als undefiniert gilt
#                    path : widgetpfad dieses Menues
#                    dp   : aktueller Diagrammwidgetpfad 
#------------------------------------------------------------------------------
#
proc diagsetundefval {path dp} {

  # Diagramm und Statusvariablen sichtbar machen
  #
  global diagdata status

  # falls toplevel schon existiert, Fenster hervorheben
  #
  if {[winfo exist $path]} {
      myraise $path
      return
  }

  # toplevel erzeugen
  #
  toplevel $path

  # Bitmap fuer icon setzen
  #
  global env
  wm iconbitmap $path @$env(DV_HOME)/bitmaps/statist.xbm
  wm iconname   $path Layout

  # Titel setzen
  #
  set diag [string toupper $diagdata($dp.frametitle)]
  wm title $path "$diag undefined Value" 

  # Diagramm und Statusvariablen sichtbar machen
  #
  global diagdata status

  # undefinierten Wert in Puffervariable
  #
  set status($dp.undefvalbuffer) $diagdata($dp.undefval)

  # erzeuge Rahmen fuer Menue
  #
  frame $path.menu -border 1 -relief raised
  pack $path.menu -ipadx 10 -ipady 5 -pady 10 -padx 10

  # erzeuge Ueberschrift fuer Menu
  #
  label $path.menu.head -text "Enter undefined Value"
  pack $path.menu.head

  # erzeuge Rahmen fuer Eingabezeile
  #
  frame $path.menu.input 
  pack $path.menu.input -expand true  -fill x

   # erzeuge Eingabeaufforderung
   #
   label $path.menu.input.req -text "undefined value: "
   pack $path.menu.input.req -side left

   # erzeuge Eingabefeld fuer undefinierten Wert
   #
   entry $path.menu.input.input -width 15 -text status($dp.undefvalbuffer)\
         -relief sunken
   pack $path.menu.input.input 

  # erzeuge Rahmen fuer Knoepfe
  #
  frame $path.buttons
  pack $path.buttons -fill x -pady 5 -padx 10

  # erzeuge Ok -Knopf
  #
  button $path.buttons.ok -text " O K "\
         -command "diagsetundefvalok $path $dp; destroy $path; setoldfocus;\
                   busy {refreshwindows $dp .}"
  pack $path.buttons.ok -side left -padx 10 -expand true -fill both

  # erzeuge update-Knopf
  #
  button $path.buttons.update -text "update"\
         -command "diagsetundefvalok $path $dp; busy {refreshwindows $dp .}"
  pack $path.buttons.update -side left -padx 10 -expand true -fill both
 
  # erzeuge cancel-Knopf
  #
  button $path.buttons.cancel -text "Cancel"\
        -command "destroy $path; setoldfocus"
  pack $path.buttons.cancel -side left -padx 10 -expand true -fill both

  # alten focus speichern und neuen Focus auf das Eingabefeld
  #
  savefocus
  focus $path.menu.input.input

  # Return Bindungen realisieren
  #
  bindreturn "[findentries $path] $path" "$path.buttons.ok invoke"

  # refresh-Routine erzeugen------------------------------------------------
  #
  proc $path.refresh {path dp} {

    # Diagramm und Statusvariablen sichtbar machen
    #
    global diagdata status

    set status($dp.undefvalbuffer) $diagdata($dp.undefval)
  }
}
