### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


############################################################
# This file takes care of conversion of the save file
############################################################
proc updateSaveFile {} {
  set hash "\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#"
  global module progList children
  set versions {1.1b 1.1b2 1.1b3 1.1 "--DOTFILE VERSION--"}
  set versionChange 0

  set IN [open [glob ~]/.dotfile/$module(name)]
  gets $IN; # remove the first line
  gets $IN line
  if {![regexp "^\# Dotfile Generator version (.+)\$" $line all version]} {
    set version 1.1b
  }
  
  if {[lsearch $versions $version] == -1} {
    error "Version $version isn't in list $versions"
  }

  ############################################################
  #                 version 1.1b -> 1.1b2
  ############################################################
  if {[lsearch -exact $versions $version] < [lsearch -exact $versions 1.1b2]} {
    puts -nonewline \
	"Updating [glob ~]/.dotfile/$module(name) to version 1.1b2..."
    flush stdout
    set versionChange 1
    
    close $IN
    set OUT [open [glob ~]/.dotfile/new.$module(name) w]

    set IN [open [glob ~]/.dotfile/$module(name)]
    puts $OUT "$hash\n\# Dotfile Generator version 1.1b2\n\# $module(name) module version $module(version)\n$hash\n"

    ### reading all the configurations
    while {![regexp {^\# setup$} $line]} {
      if {[string index $line 0] == "\#" || $line == ""} {
	puts $OUT $line
      } else {
	parseSetInVer1.1b $line $IN $OUT
      }
      gets $IN line
    }

    ### reading until "scrollValue"
    while {![regexp {^\# scrollValue} $line]} {
      puts $OUT $line
      if {[gets $IN line] == -1} {
	puts "Done"
	return 1
      }
    }
    puts $OUT $line
    puts $OUT [gets $IN]
    gets $IN line
    while {[string index $line 0] != "\#"} {
      regexp {^scrollValue\((.+)\)} [lindex $line 1] all prefix
      set func {}
      foreach function $progList {
	if {[regexp "^${function}_(.+)\$" $prefix]} {
	  lappend func $function
	}
      }
      if {[llength $func] != 1} {
	puts $func
      }
      set childs ""
      foreach elm [array names children ${func}__*] {
	foreach name $children($elm) {
	  lappend childs $name
	}
      }
      set possible {}
      foreach child $childs {
	if {[regexp "_$child\$" $prefix]} {
	  lappend possible $child
	}
      }
      if {[llength $possible] != 1} {
	puts  $line
      }
      puts $OUT "setVar $func $possible [string range $line 4 end]"
      if {[gets $IN line] == -1} {
	puts "DONE"
	return 1
      }
    }

    
    close $OUT
    exec mv [glob ~]/.dotfile/$module(name) [glob ~]/.dotfile/$module(name).old
    exec mv [glob ~]/.dotfile/new.$module(name) [glob ~]/.dotfile/$module(name)
    puts "DONE"
  }
  ############################################################
  #               version 1.1b2 -> 1.1b3
  ############################################################
  if {[lsearch -exact $versions $version] < [lsearch -exact $versions 1.1b3]} {
    puts -nonewline \
	"Updating [glob ~]/.dotfile/$module(name) to version 1.1b3..."
    flush stdout
    set versionChange 1
    
    set OUT [open [glob ~]/.dotfile/new.$module(name) w]
    puts $OUT "$hash\n\# Dotfile Generator version 1.1b3"
    set counter 0
    while {[gets $IN line] != -1} {
      if {[regexp {set setup\(onePage\) \{(.)\}} $line all which]} {
	if {$which == "1"} {
	  puts $OUT "set setup(whatToGenerate) {one}"
	} else {
	  puts $OUT "set setup(whatToGenerate) {selected}"
	}
      } elseif {[string match "set fillOutCounter*" $line]} {
	puts $OUT "set fillOutCounter [expr $counter +1]"
      } else {
	puts $OUT $line
      }
      if {[regexp {^set fillList\(([^\)]+)\) \{(.+)\}$} $line all name list]} {
	foreach elm $list {
	  set index [lindex $elm 3]
	  if {$index > $counter} {
	    set counter $index
	  }
	}
      }
    }
    close $OUT
    exec mv [glob ~]/.dotfile/$module(name) [glob ~]/.dotfile/$module(name).old
    exec mv [glob ~]/.dotfile/new.$module(name) [glob ~]/.dotfile/$module(name)
    puts "DONE"
  }
  catch "exec rm [glob ~]/.dotfile/new.$module(name)"
  return $versionChange
}

############################################################
# This function convers the "set .." lines in ver 1.1b
############################################################      
proc parseSetInVer1.1b {line IN OUT} {
  global progList children

  ### finding the name of the function
  set lineFunc [lindex $line 1]
  set func {}
  foreach function $progList {
    if {[regexp "^${function}_(.+)\$" $lineFunc]} {
      lappend func $function
    }
  }
  if {[llength $func] == 0} {
    puts $OUT $line
  }
  if {[llength $func] == 2} {
    if {[string length [lindex $func 0]] > [string length [lindex $func 1]]} {
      set func [lindex $func 0]
    } else {
      set func [lindex $func 1]
    }
  }

  # finding the children of the function
  set childs ""
  foreach elm [array names children ${func}__*] {
    foreach name $children($elm) {
      lappend childs $name
    }
  }

  set possible {}
  foreach child $childs {
    if {[regexp "_$child\$" $lineFunc]} {
      lappend possible $child
    }
  }
  if {[llength $possible] == 0} {
    puts $OUT $line
  }
  set variable [lindex $line 1]
  ### searching for the value
  set index [expr [string first \" $line]+1]
  set escape 0
  set char [string index $line $index]
  set length [string length $line]
  set value ""
  while {!($char == "\""  && $escape == 0)} {
    append value $char
    if {$char == "\\"} {
      set escape [expr ($escape+1)%2]
    } else {
      set escape 0
    }
    if {$index == $length} {
      append value "\n"
      gets $IN line
      set index -1
    }
    incr index
    set char [string index $line $index]
  }
  
  if {[llength $possible] == 1} {
    puts $OUT "setVar $func $possible $variable {$value}"
  }
  if {[llength $possible] == 2} {
    if {[string length [lindex $possible 0]] > [string length [lindex $possible 1]]} {
      puts $OUT "setVar $func [lindex $possible 0] $variable {$value}"
    } else {
      puts $OUT "setVar $func [lindex $possible 1] $variable {$value}"
    }
  }
}

