### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


############################################################
#   funktion to insert information about the actual info
#   into the info list.
############################################################
proc print {args} {
    global answers editInfo fileHandles setup
    if {[string match [lindex $args 0]* "-file"] && [lindex $args 0] != ""} {
	set handler [lindex $args 1]
	set args [lrange $args 2 end]
	if {![info exists fileHandles($handler)]} {
	    error "Wrong handler: \"$handler\", should be one of \"[array names fileHandles]\""
	}
    } else {
	set handler [lindex [lindex $setup(dotfile) 0] 0]
    }
    append answers($handler) [join $args] "\n"
}

############################################################
#                    set the description
############################################################
proc Desc {args} {
  global editInfo desc
  set function $editInfo(name)
  set desc($function) [join $args]
}

############################################################
#               set the short description
############################################################
proc ShortDesc {args} {
  global shortDesc setup editInfo
  set function $editInfo(name)
  
  set shortDesc($function) "[join $args]"
}

############################################################
#             function to create save functions
############################################################
proc Save {funk} {
  global ok editInfo
  set function $editInfo(name)
  set ok($function) $funk
}

############################################################
#      create function to be called whenever changes
#      are made to the scheme
############################################################
proc Change {funk} {
  global editInfo changeFunc
  set function $editInfo(name)
  set changeFunc($function)  $funk
}
############################################################
#  create function to be called at startup the first time
############################################################
proc Init {funk} {
  global initFunc editInfo
  set function $editInfo(name)
  set initFunc($function) $funk
}
############################################################
#      create function to be called whenever changes
#      are made to the scheme
############################################################
proc PageEnd {funk} {
  global editInfo pageEnd
  set function $editInfo(name)
  set pageEnd($function) $funk
}
############################################################
# This function activates the change function which it
# read in changeFunc($function)
############################################################
proc setChangeFunc {} {
  global editInfo changeFunc
  set function $editInfo(name)
  if {$changeFunc($function) == ""} {
    proc makeChange {name prefix {menuCreate 0}} "global changed;UpdateActive \$name \$prefix; if {!\$menuCreate} {set changed 1}"
  } else {
    proc makeChange {name prefix {menuCreate 0}} "global changed changeElm;set changeElm \$name;UpdateActive \$name \$prefix;if {!\$menuCreate} {set changed 1}; uplevel \#0 \{$changeFunc($function)\}"
  }
}

############################################################
#        Just an alias for source...
#        used when importing template files
############################################################
proc import {file} {
  global argv
  source [lindex $argv 1]/$file
}

############################################################
#                        Edit WINDOW
############################################################
proc makeEdit {} {
  global module setup editInfo
  toplevel .edit
  pack [frame .edit.name]
  pack [frame .edit.save -bd 2 -relief ridge] -side bottom -fill x -expand yes 
  pack [frame .edit.description -bd 0] -side bottom -fill x

  label .edit.name.1 -text "name: "
  label .edit.name.2 
  pack .edit.name.1 .edit.name.2 -side left
  
  label .edit.description.desc -justify left
  pack .edit.description.desc -fill x
  pack .edit.description.desc

  wm withdraw .edit
  if {$setup(placeWindows)} {
    wm geometry .edit +300+0
  }
  wm deiconify .edit
  wm title .edit "$module(name) module"
  if {[info exists editInfo(windowLocation)]} {
    wm geometry .edit $editInfo(windowLocation)
  }
  bind .edit <Control-s> generate
  bind .edit <Meta-s> {set saveInfo($editInfo(name)) [expr ($saveInfo($editInfo(name))+1) %% 2]}
  bind .edit.description.desc <3> "setDesc \$desc(\$editInfo(name))"
}

############################################################
#           This function set the description
############################################################
proc setDesc {desc} {
  .edit.description.desc configure -text ""
  update
  set width [winfo reqwidth .edit]
  .edit.description.desc configure -text $desc \
      -wrap [expr $width-20]
}

############################################################
#   This function reset a page to it's default values
############################################################
proc resetToDefult {} {
  global editInfo loaded scrollValue fillList children state widgetArgs

  set function $editInfo(name)
  if {$function == ""} {
    error "You have to select a page befor you can run this command."
  }
  catch "destroy .edit"
  uplevel \#0 "eval unset \[info vars ${function}_*\]"
  foreach array {scrollValue fillList state} {
    if {[info exists $array]} {
      foreach elm [array names $array ${function}_*] {
	eval "unset ${array}($elm)"
      }
    }
  }
  
  unlink top ""
  catch {unset activeNivau}

  set editInfo(name) ""
  loadMenu $function

  ### seting the variables to default
  foreach name $children(${function}__top) {
    set default $widgetArgs(${function}__${name}__default)
    setVariable $name $function $default
  }

  ### calling the init function
  if {[info exists initFunc($function)]} {
    set changeElm init
    uplevel \#0 $initFunc($function)
  } else {
    # the init func, doesn't exist call change with all element activated.
    foreach child $children(${function}__top) {
      changeAll $child
    }
  }
}

############################################################
#               Quit
############################################################
proc quit {} {
  global changed
  if {$changed} {
    set answer [tk_dialog .dialog "Unsaved Information" \
		    "There's information, which haven't been saved what do you want to do" questhead 2 Quit "Dont Quit" Save]
    if {$answer == 2} saveFile
    if {$answer == 1} return
  }
  exit
}

proc expand {name {array ""}} {
  global  func
  global $func$name
  if {$array == ""} {
    eval return [set [set func][set name]]
  } else {
    eval return [set [set func][set name]($array)]
  }
}

############################################################
# This function set the What To Generate buttons on the
# bottom of the configuration page
############################################################
proc setWhatToGenerate {} {
  global setup editInfo
  if {![winfo exists .edit.save]} return

  if {$setup(whatToGenerate) == "one" || $setup(whatToGenerate) == "all"} {
    if {[winfo exists .edit.save.yes]} {
      catch "destroy .edit.save.yes .edit.save.no"
    }
    if {![winfo exists .edit.save.label]} {
      pack [label .edit.save.label]
    }
    if {$setup(whatToGenerate) == "one"} {
      .edit.save.label configure -text "Only this page will be generated"
    } else {
      .edit.save.label configure -text "All pages will be generated"
    }
  } else { ;# selected
    if {[winfo exist .edit.save.label]} {
      catch "destroy .edit.save.label"
    }
    if {![winfo exist .edit.save.yes]} {
      radiobutton .edit.save.yes -text "Will be generated" -value 1
      radiobutton .edit.save.no -text "Will not be generated" -value 0
      pack .edit.save.yes .edit.save.no -side left -expand 1
    }
    .edit.save.yes configure -variable saveInfo($editInfo(name))
    .edit.save.no configure -variable saveInfo($editInfo(name))
  }
}

############################################################
# This function tell the Dotfile Generator which global
# variable, the module what to save.
############################################################
proc SaveVars {args} {
  global saveVars
  foreach var $args {
    uniqAppend saveVars $var
  }
}
  
############################################################
# This function creates an temp. window
############################################################
proc makeTempWindow {title} {
  set counter 0
  while {[winfo exists .temp$counter]} {
    incr counter
  }
  set w .temp$counter
  toplevel $w
  wm title $w $title
  set x [expr [winfo screenwidth $w]/2 - 100 \
	     - [winfo vrootx [winfo parent $w]]]
  set y [expr [winfo screenheight $w]/2 - 100 \
	     - [winfo vrooty [winfo parent $w]]]
  wm geom $w +$x+$y
  return $w
}
