## -*- Mode: tcl -*-

## Drew J. Asson, APSB
## RPS2 Preprocessor
## File: links.tcl
## Last update: 8 February 1995

## This file contains the links necessary for supporting CASM, etc.
## They are created based on visit and exposure level special requirements.
## A class hierarchy is below.

## 
## Class hierarchy:
##                                   Group
##                       _ Within --<
##                      /            Seq
##                     /
##        Visit_Link -+--- Orient -- Orient_Visit_Link (orient from visit #)
##         /           \
## Base_Link            \              After
##         \             Visit_Seq --<
##          \                          Hold
##           \
##            Exposure_Link -- Group_FGS_Link
##

## -----------------
## Base Link Class
## -----------------

itcl_class Base_Link {
    inherit Base_PP
    
    public From "" {}
    public To "" {}
}

## ---------------------
## Base Visit link class
## ---------------------

itcl_class Visit_Link {
    inherit Base_Link

    method Visit_Num {} {
	return $visit
    }

    public visit "" {}
}

## --------------
## Visit_Seq link
## --------------

itcl_class Visit_Seq_Link {
    inherit Visit_Link

    method CASM_Report { { fd stdout } proposal_id } {
	puts $fd "(define-sequential-link"
	puts $fd "   :proposal-id $proposal_id"
	puts $fd "   :visit1-id \"$visit\""
	if { [$this isa After_Link] == 1 } {
	    puts $fd "   :visit2-id \"[$this Slot_Value public after_visit]\""
	    set by [$this By_Time]
	    set to [$this To_Time]
	    if { $by != "" } {
		puts $fd "   :minimum-separation $by"
	    } else {
		puts $fd "   :minimum-separation 0"
	    }
	    if { $to != "" } {
		puts $fd "   :maximum-separation $to"
	    } else {
		puts $fd "   :maximum-separation :plus-infinity"
	    }
	    puts $fd "   :link-type :after"
	} elseif { [$this isa Hold_Link] == 1 } {
	    puts $fd "   :minimum-separation 5184000"
	    puts $fd "   :maximum-separation :plus-infinity"
	    puts $fd "   :visit2-id \"[$this Slot_Value public on_hold_for]\""
	    puts $fd "   :link-type :on-hold-for"
	}
	puts $fd ")"
    }
}

## ------------------------------

itcl_class After_Link {
    inherit Visit_Seq_Link

    method By_Time {} {	return $by_time }
    method To_Time {} {	return $to_time }
    method After_Visit {} { return $after_visit }
	

    public by_time "" {}
    public to_time "" {}
    public after_visit "" {}
}

## ------------------------------

itcl_class Hold_Link {
    inherit Visit_Seq_Link

    public on_hold_for "" {}
    ## method On_Hold_For {} { return $on_hold_for }
    method On_Hold_For {} { return [Visit_Num]}
}

## ------------
## Orient links
## ------------

itcl_class Orient_Link {
    inherit Visit_Link

    constructor {config} {
	global Visit_List

	$Visit_List($visit) Add_Orient $this
    }

    proc CASM_Base_Report { fd proposal_id visit_id } {
	puts $fd "   :proposal-id $proposal_id"
	puts $fd "   :visit-id \"$visit_id\""
    }

    method CASM_Report { { fd stdout } proposal_id } {
	if { $from == "" || [string tolower $from] == "nominal" } {
	    if { $from == "" } {
		puts $fd "(define-absolute-orient"
	    } else {
		puts $fd "(define-orient-from-nominal"
	    }
	    CASM_Base_Report $fd $proposal_id $visit
	    puts $fd "   :orient-start $angle1"
	    puts $fd "   :orient-end $angle2"
	    puts $fd ")"
	}
    }

    method From_Angle {} {
	return $angle1
    }

    method To_Angle {} {
	return $angle2
    }

    method Type_Orient {} {
	return $from
    }

    public angle1 "" {}
    public angle2 "" {}
    public from "" {}
}

## ----------------------------------

itcl_class Orient_Visit_Link {
    inherit Orient_Link

    constructor {config} {}

    method CASM_Report { { fd stdout } proposal_id } {
	puts $fd "(define-orient-from-link"
	puts $fd "   :proposal-id $proposal_id"
	puts $fd "   :visit1-id \"$visit\""
	puts $fd "   :visit2-id \"$from\""
	puts $fd "   :orient-start $angle1"
	puts $fd "   :orient-end $angle2"
	puts $fd ")"
    }
}

## -----------------
## Within links
## -----------------

itcl_class Within_Link {
    inherit Visit_Link

    constructor {config} {}

    method CASM_Report { { fd stdout } proposal_id } {
	if { [$this isa Group_Link] == 1 } {
	    puts $fd "(define-group-within"
	} elseif { [$this isa Seq_Link] == 1 } {
	    puts $fd "(define-sequential-within"
	} else {
	    puts stdout "Unknown WITHIN link ($this)"
	    return -1
	}

	puts $fd "   :proposal-id $proposal_id"
	puts $fd "   :visit-ids '([Str_To_List_Of_Strs $visit_list " "])"
	puts $fd "   :time-interval $within_time"
	puts $fd ")"
    }

    method Sorted_Visit_List {} { return [lsort -ascii $visit_list] }
    method Within_Time {} { return $within_time }

    public visit_list "" {}
    public within_time "" {}
}

## ------------------------------

itcl_class Group_Link {
    inherit Within_Link
}

## ------------------------------

itcl_class Seq_Link {
    inherit Within_Link
}

## -----------------
## Exposure links
## -----------------

itcl_class Exposure_Link {
    inherit Base_Link

    public exp "" {}
    public explist "" {}
}

## ------------------------------

itcl_class Group_FGS_Link {
    inherit Exposure_Link

    public within_time
}
