
/* Copyright (c) 1994
 *      Zbigniew Wieckowski (wieckows@cs.umn.edu)
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software under the terms of the GPL licence agreement.
 */

#ifndef _myString_h
#define _myString_h

#include <string.h>
#include <iostream.h>

static const int MAX_CONTEXTS = 10;

class string {
     int len;
     char* str;
public:
     string();
     string(const char* &, const unsigned int);
     void empty();
     ~string();
     string& assign(const char*&, const unsigned int);
     string& operator =(const string&);
     string& add(const char*&, const unsigned int);
     string& operator +=(const string&);
     string& operator +=(const char);
     char& operator[](int) const;
     int length() const;
     char* realstr() const;
//     friend ostream& operator <<(ostream& os, const string& s);
};

inline
string::string()
{
     len = 0;
     str = 0;
}

inline
string::string(const char* &s, const unsigned int slen)
{
     len = slen;
     if (len) {
	str = new char[len + 1];
	strncpy(str, s, slen);
	str[len] = '\0';
     }
     else
	str = 0;
}

inline
void
string::empty()
{
     if (str)
	  delete str;
     str = 0;
     len = 0;
}

inline
string::~string()
{
     empty();
}

inline
int
string::length() const
{
     return len;
}

inline
char*
string::realstr() const
{
   return str;
}

inline
char&
string::operator[](int elem) const
{
     return str[elem];
}

inline
ostream&
operator <<(ostream& os, const string& s)
{
  if (s.length())
     os << s.realstr();
  return os;
}

#endif /*!_myString_h*/
