#!/usr/local/bin/dptcl -f
#
# set some globals...
#
set debug 0

######## *EDIT* ########
set lib_dir "/usr/lib/abwesenheit"
source $lib_dir/config.tcl

set num_cells 120
set hostname [exec /bin/hostname]
set my_days {Mon. Dien. Mitt. Donn. Frei.}
set rev_cell_binding() ""

##############################################################################
#
# first, define procs...
#
proc FormatLine {person von bis kunde phone} {
  set kunde_str [string range $kunde 0 25]
  set phone_str [string range $phone 0 13]
  return [format "%-12s%-16s%-11s%-27s%-14s" $person $von $bis $kunde_str\
          $phone_str]
}
proc Fail {msg} {
  set fileid [open "|$mail_cmd -s \"error in notify.tcl\" urban" w]
  puts $fileid "$message"
  close $fileid
}
proc Connect {} {
  global server username rpc_port server_name

  if {[catch {set server [dp_MakeRPCClient $server_name $rpc_port]}]} {
    return 0
  }
  return 1
}
proc QuitTheApp {} {
  global server

  dp_CloseRPC $server
  exit
}
##############################################################################
# parse args...
foreach arg $argv {
  switch -regexp -- $arg {
    "-d" {
      puts "debug=1..."
      set debug 1
    }
    default {
      puts "arg: $arg: don't know that one"
    }
  }
}
#set debug 1
####
# make connection to server
####
if {![Connect]} {
  puts "error making connection to server"
  exit
}


#set logfile "$lib_dir/notify.log"
#
# then get utils.tcl
#
source $lib_dir/utils.tcl
#
SetDateVars
set thiskw [eval getkw [exec date "+%d %m %Y"]]
#puts "thiskw: $thiskw"
set mail_list "{OSSC Abwesenheit fuer KW $thiskw}\
               {==========================================================}\
               {(N=Nachmittag, V=Vormittag)}\
               {}\
               {[FormatLine Person Von Bis Kunde Telefon]}\
               {[FormatLine ------- --------------- ---------- ------------------------- -------]}"
#
# now check that it's monday
if {$weekday_num != 1} {
  if {$debug} {
    puts "Can only be run on monday"
    puts "but running anyhow ..."
  }
  set shift [expr ($weekday_num - 1) * 2]
  #exit
} else {
  set shift 0
}
if {$debug} {puts "DEBUG: shift=$shift"}
#
# do some initialization...
#
LoadHolidays
LoadMessen
CellBind
InitVirginBiglist

# now get people
#FindPeople
set people [ExecRPC set people]
ReadAllPeople
#
foreach person $people {
  set real_name [GetRealName $person]
  foreach thisres $person_reservations($person) {
    #
    # format:
    # {tag} {start-cell} {end-cell} {customer} {sonst} {cust-telefon}
    #
    set real_start [lindex $thisres 1]
    set real_end [lindex $thisres 2]
    set start [expr $real_start + $shift]
    set end   [expr $real_end + $shift]
    set cust  [lindex $thisres 3]
    set sonst [lindex $thisres 4]
    set fone  [lindex $thisres 5]
    if {$start < 10} {
      #
      # here's the idea: if start-cell < 10, and today is monday, then the
      # the absence begins in this week
      #
      set start_secdate [Convert secdate $real_start]
      set end_secdate   [Convert secdate $real_end]
      set start_half    [expr "[odd $start] ? {N} : {V}"]
      set end_half      [expr "[odd $end] ? {N} : {V}"]
      set start_str "[lindex $my_days [expr $start / 2]]$start_half\
                     [lindex $start_secdate 0]"
      set end_str   "$end_half [lindex $end_secdate 0]"
      lappend mail_list "[FormatLine $real_name $start_str $end_str $cust\
                         $fone]"
      # don't clutter up output with the same person's name more than once
      set real_name ""
    }
  }
}
if {!$debug} {
  set fid [open "|$mail_cmd -s \"$mail_subject $thiskw\"\
    $recipient" w]
  set msgfid [open "notify-msg.txt" "w"]
  foreach line $mail_list {
    puts $fid "$line"
    puts $msgfid "$line"
  }
  close $fid
} else {
  foreach line $mail_list {
    puts "$line"
  }
}
QuitTheApp
