# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc group_init {group_file_name} \
{
	set group_file [open $group_file_name r]
	set group_text [file_to_list [read $group_file nonewline]]
	close $group_file
	return $group_text
}

proc group_write_to_file {group_text group_file_name} \
{
	set group_file [open $group_file_name w]
	foreach group_entry $group_text \
	{
		puts $group_file [file_to_normal $group_entry]
	}
	close $group_file
}

proc group_translate { group_text group_gid } \
{
	set index [lsearch $group_text *:*:$group_gid:*]
	if $index!=-1 {return [group_get_groupname [lindex $group_text $index]]}
	return {}
}

proc group_get_groupname {group_entry} \
{
	return [file_get_element $group_entry 0]
}

proc group_get_password {group_entry} \
{
	return [file_get_element $group_entry 1]
}

proc group_get_gid {group_entry} \
{
	return [file_get_element $group_entry 2]
}

proc group_get_groupname_gid_translate {group_text group_gid} \
{
	return "[group_translate $group_text $group_gid]($group_gid)"
}

proc group_get_groupname_gid {group_entry} \
{
	return "[group_get_groupname $group_entry]([group_get_gid $group_entry])"
}

proc group_get_gid_from_groupname_gid {groupname_gid} \
{
	set groupname_gid [split $groupname_gid "()"]
	return [lindex $groupname_gid [expr "[llength $groupname_gid] - 2"]]
}

proc group_get_gid_list {group_text username} \
{
	set gid_list {}
	foreach group_entry $group_text \
	{
		if [group_contains_user $group_entry $username] \
		{
			lappend gid_list [group_get_gid $group_entry]
		}
	}
	return $gid_list
}

proc group_contains_user {group_entry username} \
{
	if [lsearch [group_get_user_list $group_entry] $username]!=-1 {return 1}
	return 0
}

proc group_get_user_list {group_entry} \
{
	return [split [file_get_element $group_entry 3] ,]
}

proc group_get_not_user_list {group_entry} \
{
	return "[group_get_groupname $group_entry]:[group_get_password $group_entry]:[group_get_gid $group_entry]:"
}

proc group_add_user {group_text username gid_list} \
{
	set new_group_text {}
	foreach group_entry $group_text \
	{
		set group_entry [file_to_normal $group_entry]
		if { [lsearch $gid_list [group_get_gid $group_entry]] > -1 } \
		{
			set userlist [lunion [group_get_user_list $group_entry] $username]
			set userlist [lremove_spaces $userlist]
			regsub -all { } $userlist {,} userlist
			set group_entry "[group_get_not_user_list $group_entry]$userlist"
		}
		lappend new_group_text [file_to_list $group_entry]
	}
	return $new_group_text
}

proc group_remove_user {group_text username} \
{
	set new_group_text {}
	foreach group_entry $group_text \
	{
		set group_entry [file_to_normal $group_entry]
		set userlist [group_get_user_list $group_entry]
		set userindex [lsearch $userlist $username]
		if {$userindex > -1} \
		{
			set userlist [lreplace $userlist $userindex $userindex]
			set userlist [lremove_spaces $userlist]
			regsub -all { } $userlist {,} userlist
			set group_entry "[group_get_not_user_list $group_entry]$userlist"
		}
		lappend new_group_text [file_to_list $group_entry]
	}
	return $new_group_text
}
