#
# $Header: /home/rockware/cvs-main/operator/tcl/opXTerm.tcl,v 1.17 1995/03/16 12:43:22 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#
#
# OpXTerm class - create an xterm window with buttons and other features.
#

itcl_class OpXTerm {
    inherit OpTopLevel

    constructor config {
        set tmp_menus "$tl_menus $xtrm_menus"
        OpTopLevel::constructor \
            -buttons $xtrm_buttons \
            -menus $tmp_menus \
            -menu_bar $xtrm_menubar \
            -pack_option 7

        set swd [pwd]
        cd $dir
        tksteal $work_space.xterm -width 80 -height 25 -name TkStealXTerm \
            -command {xterm -iconic #+1000+1000 -T TkStealXTerm -n TkStealXTerm -w 0 -xrm "xterm*allowSendEvents:true" -geometry 250x80}

        $work_space.xterm config -relief flat
        $work_space config -bo 3 -relief groove
        
        ::pack $work_space.xterm -expand on -fill both
        bind $work_space.xterm <Destroy> "+[bind [winfo class $work_space.xterm] <Destroy>]"
        bind $work_space.xterm <Destroy> "+catch {$this delete}"
        focus $work_space.xterm
        ::update

        blt_drag&drop target $this handler \
            file_name "$this dd_recv_file"

        .control add XTerm [string range $this 6 end] "$this raise"

        wm grid $this [winfo width $this] [winfo height $this] 10 16
        cd $swd
    }
    destructor {
        .control remove XTerm [string range $this 6 end]
    }
    method config config {}
    method steal_access {} {return $this.info.xterm}
    method chdir dir {$work_space.xterm sendstring "cd $dir\n"}
    method dd_recv_file {} {
        global DragDrop
        set file $DragDrop(file_name)
        if [file isdirectory $file] {
            [steal_access] sendstring "cd $file\n"
        } {
            if [file executable $file] {
                [steal_access] sendstring "$file\n"
            } {
                [steal_access] sendstring "more $file\n"
            }
        }
    }
    proc new args {
        if {[selection own] != {}} {
            set d [opSelectionGet]
            while {![file isdirectory $d]} {set d [file dirname $d]}
            if {$d == {}} {set d .}
            puts "OpXTerm::new dir ==> '$d'"
        } {
            set d .
        }
        incr seq_num
        eval OpXTerm .xterm$seq_num -dir $d $args
    }
    public dir . {if $after_constructor "$this chdir $dir"}
    common seq_num 0
    # {command -label Quit -command {THIS delete} -underline 0}
    # {Quit . {THIS delete} {} {} {}}
    common xtrm_menus {
        {xtrm_file {
            {command -label Quit -command {.xtermConfirmQuit on -src THIS} -underline 0}}
        }
    }
    common xtrm_menubar {{File 0 xtrm_file} {Windows 0 tl_wins} {Help 0 tl_help right}}
    common xtrm_buttons {
        {Quit . {.xtermConfirmQuit on -src THIS} {} {} {}}
        {{list files} . {[THIS steal_access] sendstring "ls -F\n"} {} {} {}}
        {{What dir} . {[THIS steal_access] sendstring "pwd\n"} {} {} {}}
        {{up dir} . {[THIS steal_access] sendstring "cd ..\n"} {} {} {}}
        {{Home dir} . {[THIS steal_access] sendstring "cd ~\n"} {} {} {}}
        {{Processes} . {[THIS steal_access] sendstring "ps -aef\n"} {} {} {}}
        {{Who} . {[THIS steal_access] sendstring "who\n"} {} {} {}}
        {{Uptime} . {[THIS steal_access] sendstring "uptime\n"} {} {} {}}
        {{Top} . {[THIS steal_access] sendstring "top\n"} {} {} {}}
        {{Stop Top} . {[THIS steal_access] sendstring "q"} {} {} {}}
        {{history} . {[THIS steal_access] sendstring "history | tail -30\n"} {} {} {}}
    }
}
