#
# $Header: /home/rockware/cvs-main/operator/tcl/opHelp.tcl,v 1.13 1995/03/04 21:44:29 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#
#  7. Help, Active Help.
# The Help text is in the language specific files (opTextEnglish.tcl ...).
# 
# set HelpCmds(.control.menu.file) {set topic .control.menu}
# set HelpCmds(.control.menu.file.m) {set topic .control.menu}

# Help Handling
proc opHelp {topic {x 0} {y 0}} {
    global HelpTopics HelpCmds
    # puts $topic
    if {$topic == {}} return
    while {$topic != {} && [winfo exists $topic] && ![info exists HelpTopics([string tolower $topic])]} {
        if {[info exists HelpTopics([string tolower [winfo class $topic]])]} {
            set topic [winfo class $topic]
        } {
            set topic [winfo parent $topic]
        }
    }
    set topic [string tolower $topic]
    while {[info exists HelpCmds($topic)]} {
        eval $HelpCmds($topic)
    }
    if [info exists HelpTopics($topic)] {
        set msg $HelpTopics($topic)
    } else {
        set msg "Sorry, but no help is available for this topic"
    }
    .helpMessage on -message $msg
}
proc opHelpCreateIndexMenu {} {
    global HelpTopics
    set names [lsort [array names HelpTopics]]
    set list {}
    foreach name $names {
        if {$name != {}} {
            lappend list "command -label {$name} -command {opHelp {$name}}"
        }
    }
    lappend list "command -label {Close Help Window} -command {.helpMessage off }"
    mm_Menu help_index $list
}

proc opActiveHelpBind {w h} {
    set cmd "opActiveHelpPush {$h}"
    set e <Enter>
    bind $w $e +[bind [winfo class $w] $e]
    bind $w $e +$cmd

    set cmd {opActiveHelpPop}
    set e <Leave>
    bind $w $e +[bind [winfo class $w] $e]
    bind $w $e +$cmd
}
proc opActiveHelpPush msg {
    global OPHelpMessage OPHelpStack
    set OPHelpStack [linsert $OPHelpStack 0 $msg]
    set OPHelpMessage $msg
}
proc opActiveHelpPop {} {
    global HelpMessage OPHelpStack
    if [llength $OPHelpStack]>0 {
        set OPHelpStack [lreplace $OPHelpStack 0 0]
        set OPHelpMessage [lindex $OPHelpStack 0]
    } {
        set OPHelpStack {}
        set OPHelpMessage {}
    }
}
# End of opHelp.tcl.
