#
# $Header: /home/rockware/cvs-main/operator/tcl/opSelectServices.tcl,v 1.16 1995/03/16 12:43:21 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#
# 8. Selection support
#
proc opSelectionGet {} {
    if ![regexp {\.[^\.]*} [selection own] wname]           {return {}}
    if {[itcl_info objects $wname -isa OpDirDisplay] == {}} {return {}}
    set r {}
    catch {set r [$wname what_dir]/[selection get]}
    return $r
}

proc opMenuSelectDirTree {{files 0}} {
    set f [opSelectionGet]
    if {$f == {}} {set f [pwd]}
    if ![file isdirectory $f] {set f [file dirname $f]}
    OpDirTree :: open $f $files
}
# 9. File Selection services
#            -buttons "
#    {OK . {eval \[format {[format $callback]} \[$i.e.filename get]] ; focus $i.e.filename } {} {Open new DirView}  }
#    {Cancel . {destroy $w}}}
#    "
#
# rewrite the OpFileSelect to include message and iconbitmap.
proc opFileSelect {w app type callback} {
    set i $w.info
    OpTopLevel $w \
        -title "File Selection - $app, $type" \
        -active_help {Please select file - by drop} \
        -iconbitmap {} \
        -iconname {} \
        -name {Select File} \
        -menus {} \
        -pack_option 1

    label $i.label -text "File name"
    pack $i.label -fill x -side top
    frame $i.e
    pack $i.e -side top
    bind $i <Any-Enter> "+focus $i.e.filename"
    entry $i.e.filename -width 45 -relief sunken
    focus $i.e.filename
    bind $i.e.filename <Key-Return> \
        "+eval \[format \"$callback\" \[$i.e.filename get]]"
    bind Entry <Enter> {focus %W}
    pack $i.e.filename -side left
    button $i.e.last -text Last -command "puts \"no history support yet\"; focus $i.e.filename"
    pack $i.e.last -side right
    frame $i.id
    pack $i.id -side top -fill x
    label $i.id.app -text "Application: $app"
    pack $i.id.app -side left
    label $i.id.type -text "Expected type: $type"
    pack $i.id.type -side right
    
    # *** The following D&D code should be added to each dialog that is also a d&d target.
    blt_drag&drop target $w handler \
        file_name "
            global DragDrop
            $i.e.filename delete 0 end
            $i.e.filename insert 0 \$DragDrop(file_name)
            $i.e.filename icursor \[string length \$DragDrop(file_name)]
            tk_entrySeeCaret $i.e.filename
        "
}
# End of File Selection services
